// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Content.subproj/OWObjectStream.h,v 1.10 2001/02/15 15:11:59 kc Exp $

#import <OWF/OWAbstractObjectStream.h>

@class NSConditionLock, NSLock, NSMutableArray, NSRecursiveLock;

#define OWObjectStreamBuffer_BufferedObjectsLength 128

typedef struct _OWObjectStreamBuffer {
    unsigned int nextIndex;
    id objects[OWObjectStreamBuffer_BufferedObjectsLength];
    struct _OWObjectStreamBuffer *next;
} OWObjectStreamBuffer;


@interface OWObjectStream : OWAbstractObjectStream
{
    id *nextObjectInBuffer, *beyondBuffer;
    OWObjectStreamBuffer *first, *last;
    unsigned int count;
    BOOL endOfObjects;
    
    NSConditionLock *objectsLock;
    NSLock *endOfDataLock;
}

@end
