// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OWF/OWStream.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import <OWF/OWContentType.h>
#import <OWF/OWParameterizedContentType.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Content.subproj/OWStream.m,v 1.10 2001/02/15 15:12:00 kc Exp $")

@implementation OWStream

- (void)dealloc
{
    [fullContentType release];
    [super dealloc];
}

- (id)newCursor;
{
    return nil;
}

//

- (void)setContentType:(OWContentType *)aContentType;
{
    OWParameterizedContentType *newType;
    
    newType = [[OWParameterizedContentType alloc] initWithContentType:aContentType];
    [self setFullContentType:newType];
    [newType release];
}

- (void)setFullContentType:(OWParameterizedContentType *)aType
{
    if (aType != fullContentType) {
        [aType retain];
        [fullContentType release];
        fullContentType = aType;
    }
}

- (void)setContentTypeString:(NSString *)aString;
{
    if ([aString containsString:@";"])
        [self setFullContentType:[OWParameterizedContentType contentTypeForString:aString]];
    else
        [self setContentType:[OWContentType contentTypeForString:aString]];
}

//

- (void)dataEnd;
{
}

- (void)dataAbort;
{
}

//

- (void)waitForDataEnd;
{
}

- (BOOL)endOfData;
{
    return YES;
}

// OWContent protocol

- (OWContentType *)contentType;
{
    return [fullContentType contentType];
}

// this is not in the OWContent protocol, but should be eventually
- (OWParameterizedContentType *)fullContentType
{
    return fullContentType;
}

- (OWCursor *)contentCursor;
{
    return [self newCursor];
}

- (unsigned long int)cacheSize;
{
    return 0;
}

- (BOOL)shareable;
{
    return YES;
}


// Debugging

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];
    if (fullContentType)
        [debugDictionary setObject:fullContentType forKey:@"contentType"];

    return debugDictionary;
}

@end
