// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OWF/OWTimeStamp.h>

#import <objc/objc-class.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import <OWF/OWContentCache.h>
#import <OWF/OWContentType.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Content.subproj/OWTimeStamp.m,v 1.7 2001/02/15 15:12:00 kc Exp $")

@interface OWTimeStamp (Private)
+ (OWTimeStamp *)cacheDate:(NSDate *)aDate inCache:(OWContentCache *)contentCache notificationAddress:(id <OWAddress>)notifyAddress;
- initWithDate:(NSDate *)aDate contentType:(OWContentType *)aType;
@end


@implementation OWTimeStamp

static OWContentType *lastChangedContentType = nil;

+ (void)initialize
{
    static BOOL                 initialized = NO;

    [super initialize];
    if (initialized)
        return;
    initialized = YES;

    lastChangedContentType = [OWContentType contentTypeForString:@"TimeStamp/LastChanged"];
}

+ (OWContentType *)lastChangedContentType;
{
    return lastChangedContentType;
}

+ (OWTimeStamp *)cacheDate:(NSDate *)aDate forAddress:(id <OWAddress>)anAddress;
{
    return [self cacheDate:aDate inCache:[OWContentCache contentCacheForAddress:anAddress] notificationAddress:anAddress];
}

+ (NSDate *)dateForContentCache:(OWContentCache *)contentCache;
{
    return [(OWTimeStamp *)[contentCache peekAtContentOfType:lastChangedContentType] date];
}

+ (NSDate *)dateForAddress:(id <OWAddress>)address;
{
    OWContentCache	*contentCache;

    contentCache = [OWContentCache lookupContentCacheForAddress:address];
    if (!contentCache)
        return nil;

    return [self dateForContentCache:contentCache];
}

// Init and dealloc

- (void)dealloc;
{
    [date release];
    [super dealloc];
}


// Public API

- (NSDate *)date;
{
    return date;
}


// OWContent protocol

- (OWContentType *)contentType;
{
    return type;
}

- (unsigned long int)cacheSize;
{
    long dateClassSize;
    long selfClassSize;

    dateClassSize = ((struct objc_class *)[date class])->instance_size;
    selfClassSize = ((struct objc_class *)[self class])->instance_size;
    
    return dateClassSize + selfClassSize;
}

- (BOOL)shareable;
{
    return YES;
}

@end


@implementation OWTimeStamp (Private)

+ (OWTimeStamp *)cacheDate:(NSDate *)aDate inCache:(OWContentCache *)contentCache notificationAddress:(id <OWAddress>)notifyAddress;
{
    OWTimeStamp *stamp;

    stamp = (OWTimeStamp *)[contentCache peekAtContentOfType:lastChangedContentType];
    if ([[stamp date] isEqual:aDate])
        return stamp;

    stamp = [[self alloc] initWithDate:aDate contentType:lastChangedContentType];
    [contentCache addContent:stamp];
    [stamp release];

    return stamp;
}


- initWithDate:(NSDate *)aDate contentType:(OWContentType *)aType;
{
    [super init];
    date = [aDate retain];
    type = aType;
    return self;
}


@end

