// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Pipelines.subproj/OWContentTypeLink.h,v 1.6 2001/02/15 15:12:03 kc Exp $

#import <OmniFoundation/OFObject.h>

@class OWContentType;

@interface OWContentTypeLink : OFObject
{
    OWContentType *sourceContentType;
    OWContentType *targetContentType;
    NSString *processorClassName;
    float cost;
}

- initWithProcessorClassName:(NSString *)aProcessorClassName sourceContentType:(OWContentType *)fromContentType targetContentType:(OWContentType *)toContentType cost:(float)aCost;

- (OWContentType *)sourceContentType;
- (OWContentType *)targetContentType;
- (NSString *)processorClassName;
- (float)cost;

@end
