// Copyright 2000-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Pipelines.subproj/OWParameterizedContentType.h,v 1.4 2001/02/15 15:12:04 kc Exp $

#import <OmniFoundation/OFObject.h>

@class OWContentType, OFMultiValueDictionary;

@interface OWParameterizedContentType : OFObject <NSMutableCopying>
{
    OWContentType *contentType;
    OFMultiValueDictionary *parameters;
}

+ (OWParameterizedContentType *)contentTypeForString:(NSString *)aString;

- initWithContentType:(OWContentType *)aType;
- initWithContentType:(OWContentType *)aType parameters:(OFMultiValueDictionary *)parameters;

- (OWContentType *)contentType;
- (OFMultiValueDictionary *)parameters;

- (NSString *)objectForKey:(NSString *)aName;
- (void)setObject:(NSString *)newValue forKey:(NSString *)aName;

- (NSString *)contentTypeString;

@end
