// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OWF/OWZoneContent.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import <OWF/OWContentType.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Pipelines.subproj/OWZoneContent.m,v 1.7 2001/02/15 15:12:06 kc Exp $")

@implementation OWZoneContent

- init;
{
    return [self initWithZone:[OFZone newZone]];
}

- initWithZone:(OFZone *)aZone;
{
    self = [super initWithName:@"Zone"];
    if (!self)
        return nil;

    theZone = [aZone retain];
    return self;
}

- (OFZone *)contentZone;
{
    return theZone;
}

- (void)dealloc;
{
    [theZone release];
    [super dealloc];
}

- (OWContentType *)contentType;
{
    return [OWContentType contentTypeForString:@"Omni/AllocationZone"];
}

- (BOOL)shareable;
{
    return YES;
}

@end
