// Copyright 2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OWAuthSchemeHTTPDigest.h"

#import <Foundation/Foundation.h>
#import <OmniBase/rcsid.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/Protocols.subproj/HTTP.subproj/OWAuthSchemeHTTPDigest.m,v 1.1 2001/03/03 01:37:10 wiml Exp $");

@interface OWAuthSchemeHTTPDigest (Private)
@end

@implementation OWAuthSchemeHTTPDigest

// Init and dealloc

- init;
{
    if (![super init])
        return nil;

    return self;
}

- (void)dealloc;
{
    [nonce release];
    [opaque release];
    [super dealloc];
}

static NSString *computeDigest(NSString *username,
                               NSString *password,
                               NSData *nonce,
                               NSString *realmname,
                               NSString *method,
                               NSString *fetchPath)
{
    NSMutableString *Ax;
    NSString *A1hash, *A2hash;
    NSString *response;

    // buffer for string manipulation
    Ax = [[NSMutableString alloc] init];

    // compute A1 and its MD5-hash
    [Ax appendStrings:username, @":", realmname, @":", pass, nil];
    A1hash = [[[Ax dataUsingEncoding:NSISOLatin1StringEncoding] md5Signature] unadornedLowercaseHexString];
    [Ax deleteCharactersInRange:NSMakeRange(0, [Ax length])];
    
    // compute A2 and its MD5-hash
    [Ax appendStrings:method, @":", fetchPath, nil];
    A2hash = [[[Ax dataUsingEncoding:NSISOLatin1StringEncoding] md5Signature] unadornedLowercaseHexString];
    [Ax deleteCharactersInRange:NSMakeRange(0, [Ax length])];

    // compute the final digest
    [Ax appendStrings:A1hash, @":", nonce, @":", A2hash, nil];
    response = [[[Ax dataUsingEncoding:NSISOLatin1StringEncoding] md5Signature] unadornedLowercaseHexString];
    [Ax release];
    
    return response;
}

- (NSString *)digestHeaderStringForAddress:(OWAddress *)uri
{
    NSString *response;
    NSString *fetchPath = [[uri url] fetchPath];

    // TODO: quote correctly
    response = [NSString stringWithFormat:@"Digest username=\"%@\" realm=\"%@\" nonce=\"%@\" uri=\"%@\" response=\"%@\" algorithm=\"MD5\"",
        username,
        name,
        nonce,
        fetchPath,
        computeDigest(username, password, nonce, name, [uri methodString], fetchPath)];
    
    if (opaque)
        response = [response stringByAppendingStrings:@" opaque=\"", opaque, @"\"", nil];

    /* TODO: entity-digest headers */
    /* opaque is required for conformance; entity-digest is a transport integrity check kinda thing */

    return response;
}

// API

@end

@implementation OWAuthSchemeHTTPDigest (NotificationsDelegatesDatasources)
@end

@implementation OWAuthSchemeHTTPDigest (Private)
@end
