// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/Protocols.subproj/HTTP.subproj/OWCookiePath.h,v 1.5 2001/03/16 23:54:14 bungi Exp $

#import <OmniFoundation/OFObject.h>
#import <OmniFoundation/OFDataBuffer.h>

@class NSArray, NSMutableArray;
@class OWCookie;

@interface OWCookiePath : OFObject
{
    NSString       *_path;
    NSMutableArray *_cookies;
}

- initWithPath: (NSString *) aPath;

- (NSString *) path;

- (BOOL)appliesToPath:(NSString *)fetchPath;

- (void) addCookie: (OWCookie *) cookie;
- (void) removeCookie: (OWCookie *) cookie;
- (NSArray *) cookies;

- (OWCookie *) cookieNamed: (NSString *) name;

// For use by OWCookieDomain
- (void)addCookie: (OWCookie *) cookie andNotify: (BOOL) shouldNotify;
- (void) addNonExpiredCookiesToArray: (NSMutableArray *) array
                       usageIsSecure: (BOOL) secure;

@end

