// Copyright 2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/Protocols.subproj/OWAuthorizationCredential.h,v 1.3 2001/02/26 21:40:22 kc Exp $

#import <OmniFoundation/OFObject.h>

@class NSString, NSDate;

#import <Foundation/NSDate.h> // For NSTimeInterval
#import <OWF/OWAuthorizationRequest.h> // For OWAuthorizationType

@interface OWAuthorizationCredential : OFObject
{
    // An authorization realm is limited to one server (host, protocol, and port), and one "realm" string (for HTTP authorization).
    // For FTP authorization, the realm string is nil.
    
    NSString *hostname;      // the hostname, textual or numeric
    enum OWAuthorizationType type;      // the protocol: http, http-proxy, ftp, etc.
    unsigned port;          // the port, or 0 for the default port for this protocol
    
    NSString *realm;
    
    NSTimeInterval lastUsedTimeInterval;
    
    id keychainTag;
}

- initForRequest:(OWAuthorizationRequest *)req realm:(NSString *)authRealm;

- (NSString *)hostname;
- (enum OWAuthorizationType)type;
- (unsigned int)port;
- (NSString *)realm;  // for FTP, etc., the realm is the username

// May return nil, if there's a problem (or if this credential isn't applicable to HTTP)
- (NSString *)httpHeaderString;

// The keychain tag is an attempt to identify individual keychain items so that we can avoid asking the user to allow us access to an item we already have cached. At the moment it's an NSDictionary, but it should be opaque to preactically everyone.
- keychainTag;
- (void)setKeychainTag:newTag;

// Returns an integer describing the new credential's equivalence to the receiver (see #defines, below)
- (int)compareToNewCredential:(OWAuthorizationCredential *)other;
#define OWCredentialIsEquivalent 1  // the new credential is equivalent
#define OWCredentialWouldReplace 2  // the new credential is different, but would replace this one (eg. a new password for the same account)
#define OWCredentialIsUnrelated 3  // the new credential is unrelated to the receiver (eg. a different account)

// feedback to tell the credential how well it worked
- (void)authorizationSucceeded:(BOOL)success response:(OWHeaderDictionary *)response;

@end
