// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OWF/OWSGMLTagType.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import <OWF/OWSGMLTag.h>
#import <OWF/OWSGMLAttribute.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/SGML.subproj/OWSGMLTagType.m,v 1.15 2001/03/03 01:38:16 wiml Exp $")

@implementation OWSGMLTagType

+ (unsigned int)idAttributeIndex;
{
    return 0;
}

+ (unsigned int)classAttributeIndex;
{
    return 1;
}

+ (unsigned int)styleAttributeIndex;
{
    return 2;
}

- initWithName:(NSString *)aName dtdIndex:(unsigned int)anIndex;
{
    [super init];
    name = [aName copy];
    dtdIndex = anIndex;
    masterAttributesTagType = nil;
    attributeNames = [[NSMutableArray alloc] init];
    attributeTrie = [[OFTrie alloc] initCaseSensitive:NO];

    // TJW -- If these are going to be added to every tag the first time it is used, just
    // add them now (moving this code of Corwin's here from -attributeTrie).  This prevents
    // having to create a bunch of lowercase strings on each tag parse to do the check to
    // see if the attributes are already present.
// #warning slow and stupid, remove someday.
// WJS 2/4/01 -- I'm not sure what would be faster, but I can definitely say this isn't stupid -- all tags do have these attributes.
    [self addAttributeNamed:@"id"];
    [self addAttributeNamed:@"class"];
    [self addAttributeNamed:@"style"];

    return self;
}

- (void)dealloc;
{
    [name release];
    [masterAttributesTagType release];
    [attributeNames release];
    [attributeTrie release];
}

- (NSString *)name;
{
    return name;
}

- (unsigned int)dtdIndex;
{
    return dtdIndex;
}

- (OWSGMLTagType *)masterAttributesTagType;
{
    if (masterAttributesTagType)
        return [masterAttributesTagType masterAttributesTagType];
    return self;
}

- (NSArray *)attributeNames;
{
    if (masterAttributesTagType)
        return [masterAttributesTagType attributeNames];
    return attributeNames;
}

- (OFTrie *)attributeTrie
{
    if (masterAttributesTagType)
        return [masterAttributesTagType attributeTrie];
    return attributeTrie;
}

- (BOOL)contentIsNotValidSGML
{
    return contentIsNotValidSGML;
}

- (void)shareAttributesWithTagType:(OWSGMLTagType *)aTagType;
{
    unsigned int attributeIndex, attributeCount;

    aTagType = [aTagType masterAttributesTagType];
    if (aTagType == self)
        return;

    masterAttributesTagType = [aTagType retain];
    attributeCount = [attributeNames count];
    for (attributeIndex = 0;
         attributeIndex < attributeCount;
         attributeIndex++) {
         [masterAttributesTagType addAttributeNamed:[attributeNames objectAtIndex:attributeIndex]];
    }
    [attributeNames release];
    [attributeTrie release];
    attributeNames = nil;
    attributeTrie = nil;
}

- (unsigned int)addAttributeNamed:(NSString *)attributeName;
{
    unsigned int newAttributeIndex;
    OWSGMLAttribute *attribute;

    if (masterAttributesTagType)
        return [masterAttributesTagType addAttributeNamed:attributeName];

    if ([attributeNames containsObject:attributeName])
        return [attributeNames indexOfObject:attributeName];

    newAttributeIndex = [attributeNames count];
    attribute = [[OWSGMLAttribute alloc] initWithOffset:newAttributeIndex];
    [attributeNames addObject:attributeName];
    [attributeTrie addBucket:attribute forString:attributeName];
    [attribute release];
    return newAttributeIndex;
}

- (unsigned int)indexOfAttribute:(NSString *)attributeName;
{
    if (masterAttributesTagType)
        return [masterAttributesTagType addAttributeNamed:attributeName];

    return [attributeNames indexOfObject:attributeName];
}

- (unsigned int)attributeCount;
{
    if (masterAttributesTagType)
        return [masterAttributesTagType attributeCount];
    else
        return [attributeNames count];
}

- (BOOL)hasAttributeNamed:(NSString *)attributeName;
{
    if (masterAttributesTagType)
        return [masterAttributesTagType hasAttributeNamed:attributeName];

    return [attributeNames containsObject:attributeName];
}

- (void)setContentIsNotValidSGML:(BOOL)newValue;
{
    contentIsNotValidSGML = newValue;
}

- (OWSGMLTag *)attributelessStartTag;
{
    if (!attributelessStartTag)
        attributelessStartTag = [OWSGMLTag retainedTagWithTokenType:OWSGMLTokenTypeStartTag tagType:self];
    return attributelessStartTag;
}

- (OWSGMLTag *)attributelessEndTag;
{   
    if (!attributelessEndTag)
        attributelessEndTag = [OWSGMLTag retainedTagWithTokenType:OWSGMLTokenTypeEndTag tagType:self];
    return attributelessEndTag;
}

// Debugging

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];

    if (name)
        [debugDictionary setObject:name forKey:@"name"];
    [debugDictionary setObject:[NSString stringWithFormat:@"%d", dtdIndex] forKey:@"dtdIndex"];
    if (masterAttributesTagType)
        [debugDictionary setObject:masterAttributesTagType forKey:@"masterAttributesTagType"];
    if (attributeNames)
        [debugDictionary setObject:attributeNames forKey:@"attributeNames"];
    if (attributeTrie)
        [debugDictionary setObject:attributeTrie forKey:@"attributeTrie"];

    return debugDictionary;
}

@end
