// Copyright 2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OWF/CSS.subproj/OWCSSTokenizer.h,v 1.8 2001/05/11 12:08:34 wjs Exp $

#import <OmniBase/OBObject.h>

@class OFCharacterScanner;

typedef enum {
    OWCSSTokenIdentifier = 1,
    OWCSSTokenString = 2,
    OWCSSTokenPunctuation = 4,
    OWCSSTokenWhitespace = 8,
    OWCSSTokenNumber = 16,
    OWCSSTokenFunction = 32,
    OWCSSTokenEOF = 64,
} OWCSSTokenType;

@interface OWCSSTokenizer : OBObject
{
    OWCSSTokenType lastTokenType;
    BOOL scannerHasRewindMark;
    
    OFCharacterScanner *scanner;
}

- initWithScanner:(OFCharacterScanner *)aScanner;

// API
- (OWCSSTokenType)getNextToken:(id *)nextTokenPointer;
- (OWCSSTokenType)getNextToken:(id *)nextTokenPointer skipWhitespace:(BOOL)skipWhitespace;
- (OWCSSTokenType)getNextToken:(id *)nextTokenPointer excludingIdentifiers:(BOOL)excludingIdentifiers excludingNumbers:(BOOL)excludingNumbers;
- (void)ungetLastToken;

- (BOOL)skipTokensUpToAndIncludingPunctuation:(NSString *)punctuationString;

@end
