// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OWF/OWSimpleTarget.h,v 1.3 2001/03/08 02:49:42 kc Exp $

#import <OmniFoundation/OFObject.h>

@class NSConditionLock;
@class OWContentInfo, OWContentType;

#import <OmniFoundation/OFWeakRetainConcreteImplementation.h>
#import <OWF/OWContentProtocol.h>
#import <OWF/OWTargetProtocol.h>

@interface OWSimpleTarget : OFObject <OWTarget, OFWeakRetain>
{
    OWContentInfo *parentContentInfo;
    OWContentType *targetContentType;
    NSConditionLock *resultLock;
    id <OWContent> resultingContent;
    BOOL acceptsAlternateContent;
    OFWeakRetainConcreteImplementation_IVARS;
}

- initWithParentContentInfo:(OWContentInfo *)contentInfo targetContentType:(OWContentType *)contentType;

- (void)setAcceptsAlternateContent:(BOOL)shouldAcceptAlternateContent;
- (id <OWContent>)resultingContent;

OFWeakRetainConcreteImplementation_INTERFACE

@end
