// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OWF/OWContentTypeLink.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import <OWF/OWContentType.h>

RCS_ID("$Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OWF/Pipelines.subproj/OWContentTypeLink.m,v 1.9 2001/03/05 02:11:08 kc Exp $")

@implementation OWContentTypeLink

- initWithProcessorClassName:(NSString *)aProcessorClassName sourceContentType:(OWContentType *)fromContentType targetContentType:(OWContentType *)toContentType cost:(float)aCost;
{
    if (![super init])
	return nil;

    processorClassName = [aProcessorClassName copyWithZone:[self zone]];
    sourceContentType = fromContentType;
    targetContentType = toContentType;
    cost = aCost;

    return self;
}

- (void)dealloc;
{
    [processorClassName release];
    [super dealloc];
}

//

- (OWContentType *)sourceContentType;
{
    return sourceContentType;
}

- (OWContentType *)targetContentType;
{
    return targetContentType;
}

- (NSString *)processorClassName;
{
    return processorClassName;
}

- (float)cost;
{
    return cost;
}

// Debugging

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];

    [debugDictionary setObject:[sourceContentType contentTypeString] forKey:@"sourceContentType"];
    [debugDictionary setObject:[targetContentType contentTypeString] forKey:@"targetContentType"];
    [debugDictionary setObject:processorClassName forKey:@"processorClass"];
    [debugDictionary setObject:[NSString stringWithFormat:@"%1.0f", cost] forKey:@"cost"];

    return debugDictionary;
}

@end
