// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/Protocols.subproj/HTTP.subproj/OWAuthorizationServer.h,v 1.9 2001/02/15 15:12:18 kc Exp $

#import <OmniFoundation/OFObject.h>

@class NSArray;
@class OWAddress, OWHeaderDictionary;

@interface OWAuthorizationServer : OFObject
{
    NSString *hostAddress;
    NSString *authorizationType; // @"www" or @"proxy"
    NSMutableDictionary *realmsByName;
    NSMutableDictionary *realmsByPath;
}

+ (OWAuthorizationServer *)serverForAddress:(OWAddress *)address;
+ (OWAuthorizationServer *)newServerForAddress:(OWAddress *)address;

+ (OWAuthorizationServer *)serverForProxy:(NSString *)netLocation;
+ (OWAuthorizationServer *)newServerForProxy:(NSString *)netLocation;

- (NSArray *)credentialsForPath:(NSString *)path;
- (void)generateCredentialsForChallenge:(OWHeaderDictionary *)challenge path:(NSString *)path reprompt:(BOOL)shouldReprompt;
- (NSString *)hostAddress;

@end
