// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/SGML.subproj/OWSGMLTagType.h,v 1.11 2001/02/15 15:12:26 kc Exp $

#import <OmniFoundation/OFTrieBucket.h>

@class NSArray, NSMutableArray;
@class OFTrie;
@class OWSGMLTag;

@interface OWSGMLTagType : OFTrieBucket
{
@public
    NSString *name;
    unsigned int dtdIndex;
    OWSGMLTagType *masterAttributesTagType;
    NSMutableArray *attributeNames;
    OFTrie *attributeTrie;
    BOOL contentIsNotValidSGML;

    OWSGMLTag *attributelessStartTag;
    OWSGMLTag *attributelessEndTag;
    /* TODO: attributelessEmptyTag for XML ? */
}

// Attributes common to all tags
+ (unsigned int)idAttributeIndex;
+ (unsigned int)classAttributeIndex;
+ (unsigned int)styleAttributeIndex;

// Init
- initWithName:(NSString *)aName dtdIndex:(unsigned int)anIndex;

// API
- (NSString *)name;
- (unsigned int)dtdIndex;
- (OWSGMLTagType *)masterAttributesTagType;
- (NSArray *)attributeNames;
- (OFTrie *)attributeTrie;
- (BOOL)contentIsNotValidSGML;

- (void)shareAttributesWithTagType:(OWSGMLTagType *)aTagType;
- (unsigned int)addAttributeNamed:(NSString *)attributeName;
- (unsigned int)indexOfAttribute:(NSString *)attributeName;
- (unsigned int)attributeCount;
- (BOOL)hasAttributeNamed:(NSString *)attributeName;

- (void)setContentIsNotValidSGML:(BOOL)newValue;

- (OWSGMLTag *)attributelessStartTag;
- (OWSGMLTag *)attributelessEndTag;

@end

static inline unsigned int tagTypeDtdIndex(OWSGMLTagType *tagType)
{
    return tagType->dtdIndex;
}
