// Copyright 2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OWF/CSS.subproj/OWCSSIdentifier.h,v 1.17 2001/05/11 14:35:24 wjs Exp $

#import <OmniFoundation/OFTrieBucket.h>

@class OFTrie;

#import "OWCSSDeclarations.h" // for CSSDeclarationsCount

@interface OWCSSIdentifier : OFTrieBucket
{
    NSString *string;
    unsigned int declarationIndex;
}

+ (OFTrie *)identifierTrie;

// API
- (NSString *)string;
- (void)setDeclarationIndex:(unsigned int)newIndex;
- (unsigned int)declarationIndex;

//
- (BOOL)isFontFamilyIdentifier;
- (BOOL)isFontSizeIdentifier;
- (BOOL)isFontSizeAdjustIdentifier;
- (BOOL)isFontStretchIdentifier;
- (BOOL)isFontStyleIdentifier;
- (BOOL)isFontVariantIdentifier;
- (BOOL)isFontWeightIdentifier;

@end

#import <OWF/FrameworkDefines.h>

OWF_EXTERN OWCSSIdentifier *OWCSSPropertyNameIdentifiers[CSSDeclarationsCount];

// functions
OWF_EXTERN OWCSSIdentifier *OWCSSURLIdentifier;

// units
OWF_EXTERN OWCSSIdentifier *OWCSSEMIdentifier, *OWCSSEXIdentifier, *OWCSSPXIdentifier, *OWCSSINIdentifier, *OWCSSCMIdentifier, *OWCSSMMIdentifier, *OWCSSPTIdentifier, *OWCSSPCIdentifier, *OWCSSPercentIdentifier;

// shared
OWF_EXTERN OWCSSIdentifier *OWCSSNoneIdentifier, *OWCSSNormalIdentifier, *OWCSSInheritIdentifier;
OWF_EXTERN OWCSSIdentifier *OWCSSAutoIdentifier, *OWCSSCenterIdentifier;
OWF_EXTERN OWCSSIdentifier *OWCSSFixedIdentifier;

// background: [<'background-color'> || <'background-image'> || <'background-repeat'> || <'background-attachment'> || <'background-position'>] | inherit
OWF_EXTERN OWCSSIdentifier *OWCSSBackgroundIdentifier;
// background-attachment: scroll | fixed | inherit
OWF_EXTERN OWCSSIdentifier *OWCSSBackgroundAttachmentIdentifier;
OWF_EXTERN OWCSSIdentifier *OWCSSScrollIdentifier;
// background-image: <uri> | none | inherit
OWF_EXTERN OWCSSIdentifier *OWCSSBackgroundImageIdentifier;
// background-color: <color> | transparent | inherit
OWF_EXTERN OWCSSIdentifier *OWCSSBackgroundColorIdentifier;
OWF_EXTERN OWCSSIdentifier *OWCSSTransparentIdentifier;
// background-position: [ [ <percentage> | <length> ]{1,2} | [ [top | center | bottom] || [left | center | right] ] ] | inherit
OWF_EXTERN OWCSSIdentifier *OWCSSBackgroundPositionIdentifier;
// background-repeat: repeat | repeat-x | repeat-y | no-repeat | inherit
OWF_EXTERN OWCSSIdentifier *OWCSSBackgroundRepeatIdentifier;
OWF_EXTERN OWCSSIdentifier *OWCSSRepeatIdentifier, *OWCSSRepeatXIdentifier, *OWCSSRepeatYIdentifier, *OWCSSNoRepeatIdentifier;

// bottom: <length> | <percentage> | auto | inherit
OWF_EXTERN OWCSSIdentifier *OWCSSBottomIdentifier;

// clear: none | left | right | both | inherit
OWF_EXTERN OWCSSIdentifier *OWCSSClearIdentifier;

// color: <color> | inherit 
OWF_EXTERN OWCSSIdentifier *OWCSSColorIdentifier;

// display: inline | block | list-item | run-in | compact | marker | table | inline-table | table-row-group | table-header-group | table-footer-group | table-row | table-column-group | table-column | table-cell | table-caption | none | inherit 
OWF_EXTERN OWCSSIdentifier *OWCSSDisplayIdentifier;
OWF_EXTERN OWCSSIdentifier *OWCSSInlineIdentifier, *OWCSSBlockIdentifier, *OWCSSListItemIdentifier, *OWCSSRunInIdentifier, *OWCSSCompactIdentifier, *OWCSSMarkerIdentifier, *OWCSSTableIdentifier, *OWCSSInlineTableIdentifier, *OWCSSTableRowGroupIdentifier, *OWCSSTableHeaderGroupIdentifier, *OWCSSTableFooterGroupIdentifier, *OWCSSTableRowIdentifier, *OWCSSTableColumnGroupIdentifier, *OWCSSTableColumnIdentifier, *OWCSSTableCellIdentifier, *OWCSSTableCaptionIdentifier;

// float: left | right | none | inherit 
OWF_EXTERN OWCSSIdentifier *OWCSSFloatIdentifier;

// font: [ [ <font-style> || <font-variant> || <font-weight> ]? <font-size> [ / <line-height> ]? <font-family> ] | caption | icon | menu | message-box | small-caption | status-bar | inherit
OWF_EXTERN OWCSSIdentifier *OWCSSFontIdentifier;
OWF_EXTERN OWCSSIdentifier *OWCSSCaptionIdentifier, *OWCSSIconIdentifier, *OWCSSMenuIdentifier, *OWCSSMessageBoxIdentifier, *OWCSSSmallCaptionIdentifier, *OWCSSStatusBarIdentifier;
// font-family: [[ <family-name> | serif | sans-serif | cursive | fantasy | monospace ],]* [<family-name> | <generic-family>] | inherit 
OWF_EXTERN OWCSSIdentifier *OWCSSFontFamilyIdentifier;
OWF_EXTERN OWCSSIdentifier *OWCSSSerifIdentifier, *OWCSSSansSerifIdentifier, *OWCSSCursiveIdentifier, *OWCSSFantasyIdentifier, *OWCSSMonospaceIdentifier;
// font-size: [xx-small | x-small | small | medium | large | x-large | xx-large ] | [ larger | smaller ] | <length> | <percentage> | inherit 
OWF_EXTERN OWCSSIdentifier *OWCSSFontSizeIdentifier;
OWF_EXTERN OWCSSIdentifier *OWCSSXXSmallIdentifier, *OWCSSXSmallIdentifier, *OWCSSSmallIdentifier, *OWCSSMediumIdentifier, *OWCSSLargeIdentifier, *OWCSSXLargeIdentifier, *OWCSSXXLargeIdentifier, *OWCSSLargerIdentifier, *OWCSSSmallerIdentifier;
// font-size-adjust: <number> | none | inherit
OWF_EXTERN OWCSSIdentifier *OWCSSFontSizeAdjustIdentifier;
// font-stretch: normal | wider | narrower | ultra-condensed | extra-condensed | condensed | semi-condensed | semi-expanded | expanded | extra-expanded | ultra-expanded | inherit
OWF_EXTERN OWCSSIdentifier *OWCSSFontStretchIdentifier;
OWF_EXTERN OWCSSIdentifier *OWCSSWiderIdentifier, *OWCSSNarrowerIdentifier, *OWCSSUltraCondensedIdentifier, *OWCSSExtraCondensedIdentifier, *OWCSSCondensedIdentifier, *OWCSSSemiCondensedIdentifier, *OWCSSSemiExpandedIdentifier, *OWCSSExpandedIdentifier, *OWCSSExtraExpandedIdentifier, *OWCSSUltraExpandedIdentifier;
// font-style: normal | italic | oblique | inherit
OWF_EXTERN OWCSSIdentifier *OWCSSFontStyleIdentifier;
OWF_EXTERN OWCSSIdentifier *OWCSSItalicIdentifier, *OWCSSObliqueIdentifier;
// font-variant: normal | small-caps | inherit
OWF_EXTERN OWCSSIdentifier *OWCSSFontVariantIdentifier;
OWF_EXTERN OWCSSIdentifier *OWCSSSmallCapsIdentifier;
// font-weight: normal | bold | bolder | lighter | 100 | 200 | 300 | 400 | 500 | 600 | 700 | 800 | 900 | inherit 
OWF_EXTERN OWCSSIdentifier *OWCSSFontWeightIdentifier;
OWF_EXTERN OWCSSIdentifier *OWCSSBoldIdentifier, *OWCSSBolderIdentifier, *OWCSSLighterIdentifier;

// height: <length> | <percentage> | auto | inherit
OWF_EXTERN OWCSSIdentifier *OWCSSHeightIdentifier;

// left: <length> | <percentage> | auto | inherit
OWF_EXTERN OWCSSIdentifier *OWCSSLeftIdentifier;

// line-height: normal | <number> | <length> | <percentage> | inherit 
OWF_EXTERN OWCSSIdentifier *OWCSSLineHeightIdentifier;

// margin: [ <length> | <percentage> | auto | inherit ] {1,4} | inherit
OWF_EXTERN OWCSSIdentifier *OWCSSMarginIdentifier;
// margin-left, margin-right, margin-top, margin-bottom: : <length> | <percentage> | auto | inherit
OWF_EXTERN OWCSSIdentifier *OWCSSMarginLeftIdentifier, *OWCSSMarginRightIdentifier, *OWCSSMarginTopIdentifier, *OWCSSMarginBottomIdentifier;

// position: static | relative | absolute | fixed | inherit
OWF_EXTERN OWCSSIdentifier *OWCSSPositionIdentifier;
OWF_EXTERN OWCSSIdentifier *OWCSSStaticIdentifier, *OWCSSRelativeIdentifier, *OWCSSAbsoluteIdentifier;

// right: <length> | <percentage> | auto | inherit
OWF_EXTERN OWCSSIdentifier *OWCSSRightIdentifier;

// text
// text-align: left | right | center | justify | <string> | inherit 
OWF_EXTERN OWCSSIdentifier *OWCSSTextAlignIdentifier;
OWF_EXTERN OWCSSIdentifier *OWCSSJustifyIdentifier;

// text-decoration: none | [ underline || overline || line-through || blink ] | inherit
OWF_EXTERN OWCSSIdentifier *OWCSSTextDecorationIdentifier;
OWF_EXTERN OWCSSIdentifier *OWCSSUnderlineIdentifier, *OWCSSOverlineIdentifier, *OWCSSLineThroughIdentifier, *OWCSSBlinkIdentifier;

// text-indent: <length> | <percentage> | inherit
OWF_EXTERN OWCSSIdentifier *OWCSSTextIndentIdentifier;

// top: <length> | <percentage> | auto | inherit
OWF_EXTERN OWCSSIdentifier *OWCSSTopIdentifier;

// vertical-align: baseline | sub | super | top | text-top | middle | bottom | text-bottom | <percentage> | <length> | inherit
OWF_EXTERN OWCSSIdentifier *OWCSSVerticalAlignIdentifier;
OWF_EXTERN OWCSSIdentifier *OWCSSBaselineIdentifier, *OWCSSSubIdentifier, *OWCSSSuperIdentifier, *OWCSSTextTopIdentifier, *OWCSSMiddleIdentifier, *OWCSSTextBottomIdentifier;

// visibility: inherit | visible | hidden
OWF_EXTERN OWCSSIdentifier *OWCSSVisibilityIdentifier;
OWF_EXTERN OWCSSIdentifier *OWCSSVisibleIdentifier, *OWCSSHiddenIdentifier;

// white-space: normal | pre | nowrap | inherit
OWF_EXTERN OWCSSIdentifier *OWCSSWhiteSpaceIdentifier;
OWF_EXTERN OWCSSIdentifier *OWCSSPreIdentifier, *OWCSSNoWrapIdentifier;

// width: <length> | <percentage> | auto | inherit
OWF_EXTERN OWCSSIdentifier *OWCSSWidthIdentifier;

// z-index: auto | <integer>
OWF_EXTERN OWCSSIdentifier *OWCSSZIndexIdentifier;


// @ rules (eg @media, @import)
OWF_EXTERN OWCSSIdentifier *OWCSSMediaIdentifier, *OWCSSImportIdentifier, *OWCSSPageIdentifier;

// media types (for @media and @import)
OWF_EXTERN OWCSSIdentifier *OWCSSAllIdentifier, *OWCSSAuralIdentifier, *OWCSSBrailleIdentifier, *OWCSSEmbossedIdentifier, *OWCSSHandheldIdentifier, *OWCSSPrintIdentifier, *OWCSSProjectionIdentifier, *OWCSSScreenIdentifier, *OWCSSTTYIdentifier, *OWCSSTVIdentifier;

