// Copyright 1999-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OWF/OWNetLocation.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

RCS_ID("$Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OWF/Content.subproj/Address.subproj/OWNetLocation.m,v 1.10.6.5 2001/08/24 08:17:14 kc Exp $")

@implementation OWNetLocation

+ (OWNetLocation *)netLocationWithString:(NSString *)aNetLocation;
{
    NSString *aUsername = nil, *aPassword = nil;
    NSString *aHostname = nil, *aPort = nil;
    NSArray *temp;

    if (aNetLocation == nil)
	return nil;
    aHostname = aNetLocation;
    if ([aHostname containsString:@"@"]) {
	temp = [aHostname componentsSeparatedByString:@"@"];
	aUsername = [temp objectAtIndex:0];
	aHostname = [temp objectAtIndex:1];
	if ([aUsername containsString:@":"]) {
	    temp = [aUsername componentsSeparatedByString:@":"];
	    aUsername = [temp objectAtIndex:0];
	    aPassword = [temp objectAtIndex:1];
	}
    }
    if ([aHostname containsString:@":"]) {
	temp = [aHostname componentsSeparatedByString:@":"];
	aHostname = [temp objectAtIndex:0];
	aPort = [temp objectAtIndex:1];
    }
    return [[[self alloc] initWithUsername:aUsername password:aPassword hostname:aHostname port:aPort] autorelease];
}

// Init and dealloc

- initWithUsername:(NSString *)aUsername password:(NSString *)aPassword hostname:(NSString *)aHostname port:(NSString *)aPort;
{
    if (![super init])
	return nil;

    username = [aUsername retain];
    password = [aPassword retain];
    hostname = [aHostname retain];
    port = [aPort retain];

    return self;
}

- (void)dealloc;
{
    [username release];
    [password release];
    [hostname release];
    [port release];
    [shortDisplayName release];
    [super dealloc];
}

// Access methods

- (NSString *)username;
{
    return username;
}

- (NSString *)password;
{
    return password;
}

- (NSString *)hostname;
{
    return hostname;
}

- (NSString *)port;
{
    if (port == nil || [port length] == 0)
        return nil; // Ignore empty port strings
    return port;
}

- (NSString *)hostnameWithPort;
{
    NSMutableString *hostnameWithPort;

    if (port == nil)
        return hostname;
    hostnameWithPort = [NSMutableString stringWithCapacity:[hostname length] + [port length] + 1];
    if (hostname)
	[hostnameWithPort appendString:hostname];
    if (port)
	[hostnameWithPort appendStrings:@":", port, nil];
    return hostnameWithPort;
}

// API

- (NSString *)displayString;
{
    NSMutableString *displayString;

    displayString = [NSMutableString stringWithCapacity:[hostname length]];
    if (username) {
	[displayString appendString:username];
	if (password)
	    [displayString appendStrings:@":", password, nil];
	[displayString appendString:@"@"];
    }
    if (hostname)
	[displayString appendString:hostname];
    if (port)
	[displayString appendStrings:@":", port, nil];
    return displayString;
}

- (NSString *)shortDisplayString;
{
    if (!shortDisplayName) {
        NSRange useableRange;
        NSString *implicitSuffix, *implicitPrefix;
        int implicitPrefixLength;
        
        implicitSuffix = NSLocalizedStringFromTableInBundle(@".com", @"OWF", [self bundle], netlocation string to remove from addresses when displaying them in short form);
        implicitPrefix = @"www.";

        useableRange = NSMakeRange(0, [hostname length]);
        if ([hostname hasSuffix:implicitSuffix])
            useableRange.length -= [implicitSuffix length];
        implicitPrefixLength = [implicitPrefix length];
        if (useableRange.length > implicitPrefixLength && [hostname hasPrefix:implicitPrefix]) {
            useableRange.location += implicitPrefixLength;
            useableRange.length -= implicitPrefixLength;
        }

        shortDisplayName = [[hostname substringWithRange:useableRange] retain];
    }
    return shortDisplayName;
}

// OBObject subclass

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];

    if (username)
	[debugDictionary setObject:username forKey:@"username"];
    if (password)
	[debugDictionary setObject:password forKey:@"password"];
    if (hostname)
	[debugDictionary setObject:hostname forKey:@"hostname"];
    if (port)
	[debugDictionary setObject:port forKey:@"port"];

    return debugDictionary;
}

- (NSString *)shortDescription;
{
    return [self displayString];
}

@end
