// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OWF/OWFileDataStream.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

@interface OWFileDataStream (private)
@end

RCS_ID("$Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OWF/Content.subproj/OWFileDataStream.m,v 1.7 2001/02/15 15:11:58 kc Exp $")

@implementation OWFileDataStream

- initWithData:(NSData *)data;
{
    if (!data) {
	[self release];
	return nil;
    }

    if (![super init])
	return nil;

    [self writeData:data];
    [self dataEnd];

    return self;
}

- initWithContentsOfFile:(NSString *)filename;
{
    NSData *data;
    
    filename = [filename stringByExpandingTildeInPath];
    data = [[NSData alloc] initWithContentsOfFile:filename];
    self = [self initWithData:data];
    [data release];

    return self;
}

- initWithContentsOfMappedFile:(NSString *)filename;
{
    NSData *data;

    filename = [filename stringByExpandingTildeInPath];
    data = [[NSData alloc] initWithContentsOfMappedFile:filename];
    self = [self initWithData:data];
    [data release];

    return self;
}

@end
