// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OWF/Content.subproj/OWStream.h,v 1.10 2001/04/28 00:59:39 kc Exp $

#import <OWF/OWAbstractContent.h>

@class NSLock;
@class OWParameterizedContentType, OWCursor;

@interface OWStream : OWAbstractContent
{
    OWParameterizedContentType *_parameterizedContentType;
    NSLock *_parameterizedContentTypeLock;
}

- (id)newCursor;

- (void)setContentType:(OWContentType *)aType;
- (void)setFullContentType:(OWParameterizedContentType *)aType;
- (void)setContentTypeString:(NSString *)aString;
- (OWParameterizedContentType *)fullContentType;

- (void)dataEnd;
- (void)dataAbort;

- (void)waitForDataEnd;
- (BOOL)endOfData;

// OWOptionalContent protocol
- (OWCursor *)contentCursor;

@end
