// Copyright 2000-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// Created by wiml on Wed Jul 26 2000.
//
// $Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/OWDataStreamCharacterProcessor.h,v 1.6 2001/02/25 20:36:41 wiml Exp $

#import <OWF/OWProcessor.h>
#import <CoreFoundation/CFString.h>

@class OWDataStreamCharacterCursor, OWParameterizedContentType, OWPipeline;

// If this key is set in the pipeline's context dictionary, it should have a value which is an NSNumber indicating the CFStringEncoding to use regardless of the charset header(s).
extern NSString *OWEncodingOverrideContextKey;

@interface OWDataStreamCharacterProcessor : OWProcessor
{
    OWDataStreamCharacterCursor *characterCursor;
}

+ (CFStringEncoding)defaultStringEncoding;
+ (NSString *)defaultForCFEncoding:(CFStringEncoding)anEnc;
+ (CFStringEncoding)stringEncodingForDefault:(NSString *)defaultValue;

+ (CFStringEncoding)stringEncodingForContentType:(OWParameterizedContentType *)aType; // returns InvalidId if unspecified; call -defaultStringEncoding

+ (NSString *)charsetForCFEncoding:(CFStringEncoding)anEncoding;

@end
