// Copyright 2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OWFilteredAddressProcessor.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import "OWContentType.h"

RCS_ID("$Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/OWFilteredAddressProcessor.m,v 1.2 2001/04/13 21:38:28 kc Exp $")

@implementation OWFilteredAddressProcessor

static OWContentType *sourceContentType;

+ (void)initialize;
{
    OBINITIALIZE;

    sourceContentType = [OWContentType contentTypeForString:@"Omni/FilteredAddress"];
}

+ (void)didLoad;
{
    [self registerProcessorClass:self fromContentType:sourceContentType toContentType:[OWContentType wildcardContentType] cost:1.0];
}

+ (OWContentType *)sourceContentType;
{
    return sourceContentType;
}

// OWProcessor subclass

- (void)process;
{
    [NSException raise:@"FilteredAddress" format:NSLocalizedStringFromTableInBundle(@"This address has been filtered by your privacy settings", @"OWF", [self bundle], filtered address exception)];
}

@end
