// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OWF/OWNNTPProcessor.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import <OWF/OWAddress.h>
#import <OWF/OWNNTPSession.h>
#import <OWF/OWSourceProcessor.h>
#import <OWF/OWURL.h>

RCS_ID("$Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/Protocols.subproj/OWNNTPProcessor.m,v 1.10 2001/02/15 15:12:15 kc Exp $")

@implementation OWNNTPProcessor

+ (void)didLoad;
{
    [self registerProcessorClass:self fromContentType:[OWURL contentTypeForScheme:@"news"] toContentType:[OWSourceProcessor sourceContentType] cost:1.0];
}

- initWithPipeline:(OWPipeline *)aPipeline;
{
    OWAddress *newAddress;
    OWURL     *inputURL, *newURL;
    
    if (![super initWithPipeline:aPipeline])
        return nil;

    nntpAddress = (OWAddress *)[[pipeline lastContent] retain];
    inputURL    = [nntpAddress url];
    
    // If the address contains no server name, create a new address
    // with the default server name.
    if (![inputURL netLocation]) {
        // use our defaultNNTPServerHostName.  This was the only way that I could seem
        // to get the correct URL constructed.  Neither OWURL class methods didn't
        // what I needed.
        newURL = [OWURL urlWithScheme: [inputURL scheme]
                          netLocation: [OWNNTPSession defaultNNTPServerHostName]
                                 path: [inputURL schemeSpecificPart]
                               params: [inputURL params]
                                query: [inputURL query]
                             fragment: [inputURL fragment]];

        newAddress = [OWAddress addressWithURL: newURL];

        // Tell the pipeline to try again with the normalized address.
        [aPipeline addContent: newAddress];
        [aPipeline cacheContent];
        [aPipeline startProcessingContent];

        // Also, note that we have delegated our processing to another
        // processor.
        didRedirect = YES;
    }

    return self;
}

- (void)dealloc;
{
    [nntpAddress release];
    [super dealloc];
}

- (void)process;
{
    if (didRedirect)
        return;
    
    nonretainedNNTPSession = [OWNNTPSession nntpSessionForAddress: nntpAddress];
    [nonretainedNNTPSession fetchForProcessor:self inPipeline:pipeline];
    nonretainedNNTPSession = nil;
}

- (void)abortProcessing;
{
    [nonretainedNNTPSession abortFetch];
    nonretainedNNTPSession = nil;
    [super abortProcessing];
}

@end
