// Copyright 2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OWF/CSS.subproj/OWCSSDeclarations.h,v 1.17 2001/06/23 00:17:09 kc Exp $

#import <OmniFoundation/OFObject.h>

typedef enum {
    // Background
    CSSBackgroundDeclarationIndex, CSSBackgroundAttachmentDeclarationIndex, CSSBackgroundColorDeclarationIndex, CSSBackgroundImageDeclarationIndex, CSSBackgroundPositionDeclarationIndex, CSSBackgroundRepeatDeclarationIndex,
    // Bottom
    CSSBottomDeclarationIndex,
    // Clear
    CSSClearDeclarationIndex,
    // Color
    CSSColorDeclarationIndex,
    // Display
    CSSDisplayDeclarationIndex,
    // Float
    CSSFloatDeclarationIndex,
    // Font
    CSSFontDeclarationIndex, CSSFontFamilyDeclarationIndex, CSSFontSizeDeclarationIndex, CSSFontSizeAdjustDeclarationIndex, CSSFontStretchDeclarationIndex, CSSFontStyleDeclarationIndex, CSSFontVariantDeclarationIndex, CSSFontWeightDeclarationIndex,
    // Height
    CSSHeightDeclarationIndex,
    // Left
    CSSLeftDeclarationIndex,
    // Line
    CSSLineHeightDeclarationIndex,
    // Margin
    CSSMarginDeclarationIndex, CSSMarginBottomDeclarationIndex, CSSMarginLeftDeclarationIndex, CSSMarginRightDeclarationIndex, CSSMarginTopDeclarationIndex,
    // Position
    CSSPositionDeclarationIndex,
    // Right
    CSSRightDeclarationIndex,
    // Text
    CSSTextAlignDeclarationIndex, CSSTextDecorationDeclarationIndex, CSSTextIndentDeclarationIndex,
    // Top
    CSSTopDeclarationIndex,
    // Vertical-align
    CSSVerticalAlignDeclarationIndex,
    // Visibility
    CSSVisibilityDeclarationIndex, 
    // White-space
    CSSWhiteSpaceDeclarationIndex,
    // Width
    CSSWidthDeclarationIndex,
    // Z-index
    CSSZIndexDeclarationIndex,
    // Fini
    CSSDeclarationsCount
} CSSDeclarationIndexes;


@interface OWCSSDeclarations : OFObject
{
@public
    id declarations[CSSDeclarationsCount];
}

+ (OWCSSDeclarations *)declarations;

// API
- (BOOL)isEmpty;
- (BOOL)isBlock;
- (BOOL)startsNewBuilder;
- (BOOL)hasFontDeclarations;
- (id)objectAtIndex:(unsigned int)index;
- (void)setObject:(id)object atIndex:(unsigned int)index;
- (void)addEntriesFromDeclarations:(OWCSSDeclarations *)otherDeclarations;
- (void)releaseAndClearDeclarations;

@end
