// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OWF/OWCursor.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

static NSException *userAbortException;

RCS_ID("$Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OWF/Content.subproj/OWCursor.m,v 1.13 2001/08/01 02:36:31 wiml Exp $")

@implementation OWCursor

+ (void)initialize;
{
    OBINITIALIZE;

    userAbortException = [[NSException alloc] initWithName:@"UserAbort" reason:NSLocalizedStringFromTableInBundle(@"User Stopped", @"OWF", [OWCursor bundle], cursor error) userInfo:nil];
}

- initFromCursor:(id)aCursor;
{
    return [self init];
}

- (void)dealloc;
{
    [abortException release];
    [super dealloc];
}

- (id)newCursor;
{
    return [[[[self class] alloc] initFromCursor:self] autorelease];
}

// OWContent protocol

- (OWContentType *)contentType;
{
    return nil;
}

- (OWCursor *)contentCursor;
{
    return self;
}

- (unsigned long int)cacheSize;
{
    return 0;
}

- (BOOL)shareable;
{
    return YES;
}

//

- (unsigned int)seekToOffset:(int)offset fromPosition:(OWCursorSeekPosition)position;
{
    return 0;
}

- (void)abortWithException:(NSException *)anException;
{
    if (abortException == anException)
	return;
    [abortException autorelease];
    abortException = [anException retain];
}

- (void)abort;
{
    [self abortWithException:userAbortException];
}

// Debugging

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];

    if (abortException)
	[debugDictionary setObject:abortException forKey:@"abortException"];

    return debugDictionary;
}

@end
