// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OWF/OWDocumentTitle.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import <OWF/OWContentCache.h>
#import <OWF/OWContentType.h>

RCS_ID("$Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OWF/Content.subproj/OWDocumentTitle.m,v 1.11 2001/09/12 05:09:48 kc Exp $")

@implementation OWDocumentTitle

static NSLock *cacheLock;
static NSMutableDictionary *guessedTitles, *realTitles;
static NSNotificationCenter *notificationCenter;

+ (void)initialize;
{
    OBINITIALIZE;

    cacheLock = [[NSLock alloc] init];
    guessedTitles = [[NSMutableDictionary alloc] init];
    realTitles = [[NSMutableDictionary alloc] init];
    notificationCenter = [[NSNotificationCenter alloc] init];
}

+ (NSString *)titleForAddress:(id <OWAddress>)address;
{
    NSString *cacheKey;
    NSString *title;

    cacheKey = [address cacheKey];
    [cacheLock lock];
    title = [[guessedTitles objectForKey:cacheKey] retain];
    [cacheLock unlock];
    return [title autorelease];
}

+ (void)cacheRealTitle:(NSString *)aTitle forAddress:(id <OWAddress>)anAddress;
{
    NSString *cacheKey;
    NSString *cacheValue;

    if (anAddress == nil)
	return;

    cacheKey = [anAddress cacheKey];
    cacheValue = [aTitle copy];
    [cacheLock lock];
    if (aTitle != nil && ![aTitle isEqualToString:@""]) {
        [realTitles setObject:cacheValue forKey:cacheKey];
        [guessedTitles setObject:cacheValue forKey:cacheKey];
    } else {
        [realTitles removeObjectForKey:cacheKey];
        [guessedTitles removeObjectForKey:cacheKey];
    }
    [cacheLock unlock];
    [cacheValue release];

    // Give the UI a chance to respond
    [notificationCenter postNotificationName:cacheKey object:anAddress];
}

+ (void)cacheGuessTitle:(NSString *)aTitle forAddress:(id <OWAddress>)anAddress;
{
    NSString *cacheKey;
    NSString *cacheValue;

    if (anAddress == nil || aTitle == nil || [aTitle isEqualToString:@""])
	return;
    
    cacheKey = [anAddress cacheKey];
    cacheValue = [aTitle copy];
    [cacheLock lock];
    if ([realTitles objectForKey:cacheKey] == nil)
        [guessedTitles setObject:cacheValue forKey:cacheKey];
    [cacheLock unlock];
    [cacheValue release];
}

+ (void)addObserver:(id)anObserver selector:(SEL)aSelector address:(id <OWAddress>)anAddress;
{
    [notificationCenter addObserver:anObserver selector:aSelector name:[anAddress cacheKey] object:nil];
}

+ (void)removeObserver:(id)anObserver address:(id <OWAddress>)anAddress;
{
    [notificationCenter removeObserver:anObserver name:[anAddress cacheKey] object:nil];
}

+ (void)removeObserver:(id)anObserver;
{
    [notificationCenter removeObserver:anObserver];
}

@end
