// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OWF/OWFileInfo.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import <OWF/OWAddress.h>
#import <OWF/OWContentType.h>
#import <OWF/OWURL.h>

RCS_ID("$Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OWF/Content.subproj/OWFileInfo.m,v 1.9 2001/03/02 21:28:00 bungi Exp $")

@implementation OWFileInfo

static OWContentType *OWFileInfoContentType;

+ (void)initialize;
{
    OBINITIALIZE;

    OWFileInfoContentType = [OWContentType contentTypeForString:@"OWObject/OWFileInfo"];
}

+ (OWContentType *)contentType;
{
    return OWFileInfoContentType;
}

- initWithAddress:(OWAddress *)anAddress size:(NSNumber *)aSize isDirectory:(BOOL)isDirectory isShortcut:(BOOL)isShortcut lastChangeDate:(NSDate *)aDate;
{
    if (![super init])
        return nil;

    address = [anAddress retain];
    size = [aSize retain];
    flags.isDirectory = isDirectory;
    flags.isShortcut = isShortcut;
    lastChangeDate = [aDate retain];

    return self;
}

- (void)dealloc;
{
    [address release];
    [size release];
    [lastChangeDate release];
    [cachedName release];
    [super dealloc];
}

- (OWAddress *)address;
{
    return address;
}

- (NSNumber *)size;
{
    return size;
}

- (BOOL)isDirectory;
{
    return flags.isDirectory;
}

- (BOOL)isShortcut;
{
    return flags.isShortcut;
}

- (NSDate *)lastChangeDate;
{
    return lastChangeDate;
}

// Derived attributes

- (NSString *)name;
{
    if (cachedName == nil) {
        cachedName = [[address localFilename] lastPathComponent];
        if (!cachedName)
            cachedName = [NSString decodeURLString:[[address url] lastPathComponent]];
        [cachedName retain];
    }
    return cachedName;
}

- (NSString *)addressString;
{
    return [address addressString];
}

// OWContent protocol

- (OWContentType *)contentType;
{
    return OWFileInfoContentType;
}

- (OWContentInfo *)contentInfo;
{
    return nil;
}

- (unsigned long int)cacheSize;
{
    return 100;
}

- (BOOL)shareable;
{
    return YES;
}

@end
