// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/CSS.subproj/OWCSSSelectorGroup.h,v 1.10 2001/02/15 15:11:54 kc Exp $

#import <OmniFoundation/OFObject.h>

@class NSArray, NSDictionary;
@class OWCSSDeclarations, OWCSSSelector, OWCSSTokenizer;

@interface OWCSSSelectorGroup : OFObject
{
    NSArray *selectorList;
    OWCSSDeclarations *declarations;
    unsigned int position;
    unsigned int score;
}

//
- initWithTokenizer:(OWCSSTokenizer *)tokenizer withPosition:(unsigned int)newPosition;

// API
- (void)setDeclarations:(OWCSSDeclarations *)newDeclarations;
- (OWCSSDeclarations *)declarations;

- (OWCSSSelector *)lastSelector;
- (NSArray *)selectorList;
- (unsigned int)score;
- (unsigned int)count;
- (unsigned int)position;
- (NSComparisonResult) compare:(OWCSSSelectorGroup *)group;

@end
