// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Content.subproj/Address.subproj/OWAddress.h,v 1.21 2001/03/21 07:24:04 wjs Exp $

#import <OmniFoundation/OFObject.h>

@class NSArray, NSBundle, NSCharacterSet, NSData, NSMutableCharacterSet, NSScanner;
@class OWContentType, OWPipeline, OWURL;

typedef enum {
    OWAddressEffectFollowInWindow, // display in the same window
    OWAddressEffectNewBrowserWindow, // display in a new browser window
    OWAddressEffectOpenBookmarksWindow, // display in a bookmarks window
} OWAddressEffect;

#import <OWF/OWAddressProtocol.h>

@interface OWAddress : OFObject <OWAddress>
{
    OWURL *url;
    NSString *target;
    NSString *methodString;
    NSDictionary *methodDictionary;
    struct {
        unsigned int effect:3;
        unsigned int forceAlwaysUnique:1;
    } flags;
    
    // Cached information
    NSString *cacheKey;
    
    // Bonus extra information, use it any way you wish
    NSDictionary *contextDictionary;
}

+ (NSDictionary *)shortcutDictionary;
+ (void)setShortcutDictionary:(NSDictionary *)newShortcutDictionary;
+ (void)reloadShortcutDictionaryFromDefaults;
+ (void)reloadAddressFilterArrayFromDefaults;

+ (OWAddress *)addressWithURL:(OWURL *)aURL target:(NSString *)aTarget methodString:(NSString *)aMethodString methodDictionary:(NSDictionary *)aMethodDictionary effect:(OWAddressEffect)anEffect forceAlwaysUnique:(BOOL)shouldForceAlwaysUnique contextDictionary:(NSDictionary *)contextDictionary;
+ (OWAddress *)addressWithURL:(OWURL *)aURL target:(NSString *)aTarget methodString:(NSString *)aMethodString methodDictionary:(NSDictionary *)aMethodDictionary effect:(OWAddressEffect)anEffect forceAlwaysUnique:(BOOL)shouldForceAlwaysUnique;
+ (OWAddress *)addressWithURL:(OWURL *)aURL target:(NSString *)aTarget effect:(OWAddressEffect)anEffect;
+ (OWAddress *)addressWithURL:(OWURL *)aURL;
+ (OWAddress *)addressForString:(NSString *)anAddressString;
+ (OWAddress *)addressForDirtyString:(NSString *)anAddressString;
+ (OWAddress *)addressWithFilename:(NSString *)filename;

+ (NSString *)stringForEffect:(OWAddressEffect)anEffect;
+ (OWAddressEffect)effectForString:(NSString *)anEffectString;

- initWithURL:(OWURL *)aURL target:(NSString *)aTarget methodString:(NSString *)aMethodString methodDictionary:(NSDictionary *)aMethodDictionary effect:(OWAddressEffect)anEffect forceAlwaysUnique:(BOOL)shouldForceAlwaysUnique contextDictionary:(NSDictionary *)contextDictionary;
- initWithURL:(OWURL *)aURL target:(NSString *)aTarget methodString:(NSString *)aMethodString methodDictionary:(NSDictionary *)aMethodDictionary effect:(OWAddressEffect)anEffect forceAlwaysUnique:(BOOL)shouldForceAlwaysUnique;
- initWithURL:(OWURL *)aURL target:(NSString *)aTarget effect:(OWAddressEffect)anEffect;
- initWithURL:(OWURL *)aURL;

- initWithArchiveDictionary:(NSDictionary *)dictionary;

// Attributes

- (OWURL *)url;
- (OWURL *)proxyURL;
- (NSString *)methodString;
- (NSDictionary *)methodDictionary;
- (NSString *)target;
- (NSString *)localFilename;
- (NSString *)addressString;
- (BOOL)representsFile;
- (NSDictionary *)contextDictionary;
- (OWContentType *)probableContentTypeBasedOnPath;

// Displaying an address

- (NSString *)drawLabel;
- (BOOL)isVisited;
- (BOOL)isSecure;

// Exactly the same address

- (BOOL)isEqual:(id)anObject;

// Not the same address, but will fetch the same data (same except fragment)

- (BOOL)isSameDocumentAsAddress:(OWAddress *)otherAddress;

// What happens when you open this address

- (OWAddressEffect)effect;
- (NSString *)effectString;

- (NSDictionary *)archiveDictionary;

// Related addresses

- (OWAddress *)addressForRelativeString:(NSString *)relativeAddressString;
- (OWAddress *)addressForRelativeString:(NSString *)relativeAddressString target:(NSString *)aTarget effect:(OWAddressEffect)anEffect;
- (OWAddress *)addressForRelativeString:(NSString *)relativeAddressString inPipeline:(OWPipeline *)pipeline target:(NSString *)aTarget effect:(OWAddressEffect)anEffect;

- (OWAddress *)addressForDirtyRelativeString:(NSString *)relativeAddressString;

- (OWAddress *)addressWithGetQuery:(NSString *)query;
- (OWAddress *)addressWithPath:(NSString *)aPath;
- (OWAddress *)addressWithMethodString:(NSString *)newMethodString;
- (OWAddress *)addressWithMethodString:(NSString *)newMethodString methodDictionary:(NSDictionary *)newMethodDictionary forceAlwaysUnique:(BOOL)shouldForceAlwaysUnique;
- (OWAddress *)addressWithTarget:(NSString *)aTarget;
- (OWAddress *)addressWithEffect:(OWAddressEffect)newEffect;
- (OWAddress *)addressWithForceAlwaysUnique:(BOOL)shouldForceAlwaysUnique;
- (OWAddress *)addressWithoutFragment;

- (OWAddress *)addressWithContextDictionary:(NSDictionary *)newContextDictionary;
- (OWAddress *)addressWithContextObject:object forKey:(NSString *)key;

//
- (NSString *)suggestedFilename;
- (NSString *)suggestedFileType;

@end


extern NSString *OWAddressContentDataMethodKey;
extern NSString *OWAddressContentHeadersAndDataMethodKey;
extern NSString *OWAddressContentStringMethodKey;
extern NSString *OWAddressContentTypeMethodKey;
extern NSString *OWAddressBoundaryMethodKey;
extern NSString *OWAddressesToFilterDefaultName;
extern NSString *OWAddressFilteringEnabledDefaultName;

