// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Content.subproj/OWContentProtocol.h,v 1.10 2001/02/15 15:11:56 kc Exp $

#ifndef OWContentProtocolHeader
#define OWContentProtocolHeader

#import <Foundation/NSObject.h>

@class OWContentInfo, OWContentType, OWParameterizedContentType, OWCursor;

@protocol OWContent <NSObject>

- (OWContentType *)contentType;
    // Returns the content type (e.g., text/html) for this content

- (OWContentInfo *)contentInfo;
    // NOTE: Implementors MUST call [contentInfo nullifyContent] before they are dealloc'd, or contentInfo will crash.  ContentInfo does NOT retain the content, and thus needs to know when it goes away.
@end

@protocol OWOptionalContent <NSObject>
- (OWCursor *)contentCursor;
- (unsigned long int)cacheSize;
- (BOOL)shareable;
- (BOOL)contentIsValid;

// Called when a non-shareable content is about to be returned to the cache. Gives the content a chance to clean up. If the method returns NO, the content is discarded instead of recached.
- (BOOL)prepareForReturnToCache;

// This is kind of a kludge --- shouldn't every object's -contentType return their full content type? But for a transitional period, we can do this, currently only implemented in OWStream subclasses
// - (OWParameterizedContentType *)fullContentType;
@end

#endif
