// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Content.subproj/OWDocumentTitle.h,v 1.8 2001/08/14 21:45:23 kc Exp $

#import <OmniFoundation/OFObject.h>

@class NSString;

#import <OWF/OWAddressProtocol.h>

@interface OWDocumentTitle : OFObject

// Accessing titles
+ (void)cacheRealTitle:(NSString *)aTitle forAddress:(id <OWAddress>)anAddress;
+ (void)cacheGuessTitle:(NSString *)aTitle forAddress:(id <OWAddress>)anAddress;
+ (NSString *)titleForAddress:(id <OWAddress>)address;

// Notifications of changes to titles
+ (void)addObserver:(id)anObserver selector:(SEL)aSelector address:(id <OWAddress>)anAddress;
+ (void)removeObserver:(id)anObserver address:(id <OWAddress>)anAddress;
+ (void)removeObserver:(id)anObserver;

@end
