// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Pipelines.subproj/OWContentType.h,v 1.17 2001/02/15 15:12:03 kc Exp $

#import <OmniFoundation/OFObject.h>

@class OWContentTypeLink, OWConversionPathElement;
@class NSArray, NSMutableArray, NSMutableSet, NSSet, NSString;

#import <Foundation/NSDate.h> // For NSTimeInterval

@interface OWContentType : OFObject
{
    NSString *contentTypeString;
    unsigned int hash;
    NSMutableArray *links;
    NSMutableSet *reverseLinks;
    NSMutableDictionary *bestPathByType;
    NSArray *extensions;
    unsigned long hfsType, hfsCreator;
    NSTimeInterval expirationTimeInterval;

    NSString *imageName;
    NSString *readableString;
    
    struct {
        unsigned int isEncoding:1;
        unsigned int isPublic:1;
        unsigned int isInteresting:1;
    } flags;
}

+ (OWContentType *)contentTypeForString:(NSString *)aString;
+ (OWContentType *)wildcardContentType;
+ (NSArray *)contentEncodings;
+ (NSArray *)contentTypes;
+ (void)setDefaultExpirationTimeInterval:(NSTimeInterval)newTimeInterval;
+ (void)updateExpirationTimeIntervalsFromDefaults;

+ (OWContentTypeLink *)linkForTargetContentType:(OWContentType *)targetContentType fromContentType:(OWContentType *)sourceContentType orContentTypes:(NSSet *)sourceTypes;

+ (void)registerFileExtension:(NSString *)extension forContentType:(OWContentType *)contentType;
+ (OWContentType *)contentTypeForExtension:(NSString *)extension;

+ (OWContentType *)contentTypeForFilename:(NSString *)filename isLocalFile:(BOOL)isLocalFile;
- (void)setExtensions:(NSArray *)someExtensions;
- (NSArray *)extensions;
- (NSString *)primaryExtension;

- (void)setHFSType:(unsigned long)newHFSType;
- (unsigned long)hfsType;
- (void)setHFSCreator:(unsigned long)newHFSCreator;
- (unsigned long)hfsCreator;

- (void)setImageName:(NSString *)newImageName;
- (NSString *)imageName;

- (NSString *)contentTypeString;
- (NSString *)readableString;
- (BOOL)isEncoding;
    // Is this actually a Content-Encoding?
- (BOOL)isPublic;
    // Is this visible to the outside world?
- (BOOL)isInteresting;
    // Should we mention this type in our HTTP Accept headers?

// Aliases
- (void)registerAlias:(NSString *)newAlias;


// Links
- (void)linkToContentType:(OWContentType *)targetContentType usingProcessorClassName:(NSString *)aProcessorClassName cost:(float)aCost;
- (OWConversionPathElement *)bestPathForTargetContentType:(OWContentType *)targetType;
- (NSArray *)directTargetContentTypes;
- (NSSet *)directSourceContentTypes;
- (NSSet *)indirectSourceContentTypes;

// Content expiration
- (NSTimeInterval)expirationTimeInterval;
- (void)setExpirationTimeInterval:(NSTimeInterval)newTimeInterval;

// Filenames
- (NSString *)pathForEncoding:(OWContentType *)contentEncoding givenOriginalPath:(NSString *)aPath;

@end

#import <OWF/FrameworkDefines.h>

OWF_EXTERN NSTimeInterval OWContentTypeNeverExpireTimeInterval;
OWF_EXTERN NSTimeInterval OWContentTypeExpireWhenFlushedTimeInterval;
OWF_EXTERN NSString *OWContentTypeNeverExpireString;
OWF_EXTERN NSString *OWContentTypeExpireWhenFlushedString;
OWF_EXTERN NSString *OWContentTypeReloadExpirationTimeIntervalsNotificationName;
