// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Pipelines.subproj/OWTask.h,v 1.19 2001/02/25 21:36:42 kc Exp $

#import <OmniFoundation/OFObject.h>

@class NSCountedSet, NSDate, NSLock, NSMutableArray;
@class OWContentInfo;

#import <Foundation/NSDate.h> // For NSTimeInterval
#import <OmniFoundation/OFSimpleLock.h>
#import <OmniFoundation/OFMessageQueuePriorityProtocol.h>
#import <OWF/OWAddressProtocol.h>

typedef enum {
    PipelineInit, PipelineBuilding, PipelineRunning, PipelinePaused,
    PipelineAborting, PipelineDead
} PipelineState;

@interface OWTask : OFObject
{
    OWContentInfo *_contentInfo;
    NSLock *_contentInfoLock;
    OWContentInfo *parentContentInfo;
    NSLock *parentContentInfoLock;
    
    NSTimeInterval lastActivationTimeInterval;

    struct {
        unsigned int wasActiveOnLastCheck:1;
        unsigned int wasOpenedByProcessPanel:2;
    } taskFlags;
    PipelineState state;

    OFSimpleLockType displayablesSimpleLock;
    NSString *compositeTypeString;
}

+ (NSString *)HMSStringFromTimeInterval:(NSTimeInterval)interval;

// Init and dealloc
- init;
    // Designated initializer
- initWithName:(NSString *)name contentInfo:(OWContentInfo *)aContentInfo parentContentInfo:(OWContentInfo *)aParentContentInfo;

// Task management
- (void)abortTask;

// Active tree
- (BOOL)treeHasActiveChildren;
- (void)treeActiveStatusMayHaveChanged;
- (void)activateInTree;
- (void)deactivateInTree;
- (void)abortTreeActivity;

// State
- (PipelineState)state;
- (id <OWAddress>)lastAddress;

- (NSTimeInterval)timeSinceTreeActivationInterval;
- (NSTimeInterval)estimatedRemainingTimeInterval;
- (NSTimeInterval)estimatedRemainingTreeTimeInterval;

- (BOOL)hadError;
- (BOOL)isRunning;
- (BOOL)hasThread;
- (NSString *)errorNameString;
- (NSString *)errorReasonString;

- (NSString *)compositeTypeString;
- (void)calculateDeadPipelines:(unsigned int *)deadPipelines totalPipelines:(unsigned int *)totalPipelines;
- (unsigned int)workDone;
- (unsigned int)workToBeDone;
- (unsigned int)workDoneIfNotFinished;
- (unsigned int)workToBeDoneIfNotFinished;
- (unsigned int)workDoneIncludingChildren;
- (unsigned int)workToBeDoneIncludingChildren;
- (NSString *)statusString;

// Network activity panel / inspector helper methods
- (BOOL)wasOpenedByProcessPanelIndex:(unsigned int)panelIndex;
- (void)setWasOpenedByProcessPanelIndex:(unsigned int)panelIndex;

// Parent contentInfo
- (void)setParentContentInfo:(OWContentInfo *)aParentContentInfo;
- (OWContentInfo *)parentContentInfo;

// ContentInfo
- (void)setContentInfo:(OWContentInfo *)newContentInfo;
- (OWContentInfo *)contentInfo;
- (void)nullifyContentInfo;

- (void)deepFlushContentCache;
    // Flushes the content cache and all its children

// OFMessageQueue protocol helpers
- (unsigned int)taskPriority;
- (unsigned int)baseTaskPriority; // Without modifiers
- (unsigned int)taskGroup;
- (unsigned int)taskMaximumSimultaneousThreadsInGroup;

- (NSComparisonResult)comparePriority:(OWTask *)aTask;

@end
