// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/OWProcessor.h,v 1.13 2001/09/21 21:51:59 wiml Exp $

#import <OmniFoundation/OFObject.h>

@class NSArray, NSDate, NSLock, NSMutableArray, NSException;
@class OFMessageQueue;
@class OWContentType, OWCursor, OWPipeline, OWURL;

#import <OmniFoundation/OFSimpleLock.h>
#import <OmniFoundation/OFMessageQueuePriorityProtocol.h>

typedef enum {
    OWProcessorStarting, OWProcessorQueued, OWProcessorRunning, OWProcessorAborting, OWProcessorRetired
} OWProcessorStatus;

@interface OWProcessor : OFObject <OFMessageQueuePriority>
{
    OWPipeline *pipeline;

    // For display purposes
    OFSimpleLockType displayablesSimpleLock;
    OWProcessorStatus status;
    NSString *statusString;
    NSDate *firstBytesDate;
    unsigned int bytesProcessed;
    unsigned int totalBytes;
}

+ (NSString *)readableClassName;

+ (OFMessageQueue *)processorQueue;
+ (void)registerProcessorClass:(Class)aClass fromContentType:(OWContentType *)sourceContentType toContentType:(OWContentType *)targetContentType cost:(float)aCost;
+ (void)registerProcessorClass:(Class)aClass fromContentTypeString:(NSString *)sourceContentTypeString toContentTypeString:(NSString *)targetContentTypeString cost:(float)aCost;

+ (OWContentType *)contentTypeForURL:(OWURL *)request whenProxiedBy:(OWURL *)proxy;

- initWithPipeline:(OWPipeline *)aPipeline;

- (OWPipeline *)pipeline;

// Processing
- (void)startProcessingInQueue:(OFMessageQueue *)aQueue;
- (void)startProcessing;
- (void)abortProcessing;

// Status
- (void)setStatus:(OWProcessorStatus)newStatus;
- (OWProcessorStatus)status;
- (void)setStatusString:(NSString *)newStatusString;
- (void)setStatusFormat:(NSString *)aFormat, ...;
- (void)setStatusStringWithClassName:(NSString *)newStatus;
- (NSString *)statusString;

- (void)processedBytes:(unsigned int)bytes;
    // Use NSNotFound to indicate an unknown amount.
- (void)processedBytes:(unsigned int)bytes ofBytes:(unsigned int)newTotalBytes;
- (NSDate *)firstBytesDate;
- (unsigned int)bytesProcessed;
- (unsigned int)totalBytes;

@end


@interface OWProcessor (SubclassesOnly)
- (void)processBegin;
- (void)process;
- (void)processEnd;
- (void)processAbort;

// These are useful to processors which do not want to start a new thread, and which therefore subclass -startProcessing
- (void)processInThread;
- (void)retire;
- (void)handleProcessingException:(NSException *)processingException;

@end
