// Copyright 2001-2002 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OWCSSNumber.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>

#import "OWCSSIdentifier.h"

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/CSS.subproj/OWCSSNumber.m,v 1.8 2002/03/09 01:53:48 kc Exp $");

@interface OWCSSNumber (Private)
@end

@implementation OWCSSNumber

static OWCSSNumber *currentFontSizeNumber;
static OWCSSNumber *standardIndentNumber;

+ (OWCSSNumber *)numberWithFloatValue:(float)newFloatValue unitsIdentifier:(OWCSSIdentifier *)newUnitsIdentifier;
{
    return [[[self alloc] initWithFloatValue:newFloatValue unitsIdentifier:newUnitsIdentifier] autorelease];
}


+ (OWCSSNumber *)currentFontSizeNumber;
{
    return currentFontSizeNumber;
}

+ (OWCSSNumber *)standardIndentNumber;
{
    return standardIndentNumber;
}

+ (void)initialize;
{
    OBINITIALIZE;
 
    [OWCSSIdentifier class];
    currentFontSizeNumber = [[self alloc] initWithFloatValue:1.0 unitsIdentifier:OWCSSEMIdentifier];
    standardIndentNumber = [[self alloc] initWithFloatValue:2.75 unitsIdentifier:OWCSSEMIdentifier];
}

// Init and dealloc

- initWithFloatValue:(float)newFloatValue unitsIdentifier:(OWCSSIdentifier *)newUnitsIdentifier;
{
    if (![super init])
        return self;

    floatValue = newFloatValue;
    unitsIdentifier = newUnitsIdentifier;
    return self;
}


// API

- (float)floatValue;
{
    return floatValue;
}

- (OWCSSIdentifier *)unitsIdentifier;
{
    return unitsIdentifier;
}

- (BOOL)isLength;
{
    return unitsIdentifier != nil || floatValue == 0.0;
}

@end

@implementation OWCSSNumber (Private)

- (NSString *)descriptionWithLocale:(NSDictionary *)locale indent:(unsigned)level;
{
    return [NSString stringWithFormat:@"%.1f%@", floatValue, unitsIdentifier];
}

@end
