// Copyright 1997-2002 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/CSS.subproj/OWCSSStyleSheet.h,v 1.23 2002/03/09 01:53:48 kc Exp $

#import <OmniFoundation/OFObject.h>

@class NSArray, NSMutableArray, NSString, NSDictionary, NSMutableDictionary;
@class OFCharacterScanner, OFStaticArray;
@class OWAddress, OWContentInfo, OWCSSDeclarations, OWObjectStreamCursor, OWCSSSelectorGroup, OWSGMLProcessor, OWSGMLTag;

@interface OWCSSStyleSheet : OFObject
{
    NSMutableDictionary *lastSelectorsByTag;
    NSMutableDictionary *lastSelectorsByClass;
    NSMutableDictionary *lastSelectorsByID;
    NSMutableDictionary *lastSelectorsByPseudoclass;
    
    OWCSSDeclarations *globalDeclarations;
    
    unsigned int currentPosition;
}

// Read in style block 
+ (void)parseIntoDeclarations:(OWCSSDeclarations *)declarations fromString:(NSString *)string;

// Reading in sheets
- (void)parseStyleSheetString:(NSString *)sheet parentContentInfo:(OWContentInfo *)parentContentInfo;
- (void)parseStyleSheetFromURLString:(NSString *)urlString parentContentInfo:(OWContentInfo *)parentContentInfo;

// Fill in declarations object with relevant styles
- (void)addDeclarations:(OWCSSDeclarations *)declarations cssTagName:(NSString *)name tag:(OWSGMLTag *)tag tagStack:(OFStaticArray *)tagStack;
- (void)addDeclarations:(OWCSSDeclarations *)declarations cssClassName:(NSString *)name tag:(OWSGMLTag *)tag tagStack:(OFStaticArray *)tagStack;
- (void)addDeclarations:(OWCSSDeclarations *)declarations cssIDName:(NSString *)name tag:(OWSGMLTag *)tag tagStack:(OFStaticArray *)tagStack;
- (void)addDeclarations:(OWCSSDeclarations *)declarations cssPseudoClassName:(NSString *)name tag:(OWSGMLTag *)tag tagStack:(OFStaticArray *)tagStack;
- (OWCSSDeclarations *)globalDeclarations;

@end

@interface NSObject (CategoriesOfCSSStyleSheetMightImplement)
// Categorize me!
+ (id)compileColorValue:(id)oldValue;
@end