// Copyright 2001-2002 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/CSS.subproj/OWCSSTokenizer.h,v 1.10 2002/03/09 01:53:48 kc Exp $

#import <OmniBase/OBObject.h>

@class OFCharacterScanner;
@class OWAddress;

typedef enum {
    OWCSSTokenIdentifier = 1,
    OWCSSTokenString = 2,
    OWCSSTokenPunctuation = 4,
    OWCSSTokenWhitespace = 8,
    OWCSSTokenNumber = 16,
    OWCSSTokenFunction = 32,
    OWCSSTokenEOF = 64,
} OWCSSTokenType;

@interface OWCSSTokenizer : OBObject
{
    OFCharacterScanner *scanner;
    OWAddress *baseAddress;

    OWCSSTokenType lastTokenType;
    BOOL scannerHasRewindMark;
}

- initWithScanner:(OFCharacterScanner *)aScanner baseAddress:(OWAddress *)anAddress;

// API
- (OWCSSTokenType)getNextToken:(id *)nextTokenPointer;
- (OWCSSTokenType)getNextToken:(id *)nextTokenPointer skipWhitespace:(BOOL)skipWhitespace;
- (OWCSSTokenType)getNextToken:(id *)nextTokenPointer excludingIdentifiers:(BOOL)excludingIdentifiers excludingNumbers:(BOOL)excludingNumbers;
- (void)ungetLastToken;

- (BOOL)skipTokensUpToAndIncludingPunctuation:(NSString *)punctuationString;

- (OWAddress *)baseAddress;

@end
