// Copyright 1997-2002 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OWF/OWAbstractContent.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import <OWF/OWContentInfo.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Content.subproj/OWAbstractContent.m,v 1.9 2002/03/09 01:53:48 kc Exp $")

@implementation OWAbstractContent

// Init and dealloc

- init;
{
    NSString *className, *displayName;

    // TODO: should we localize this hack? Arguably there should be a class name -> displayName mapping in the localizable .strings tables.

    className = NSStringFromClass(isa);
    if ([className hasPrefix:@"OW"] ||
        [className hasPrefix:@"OI"] ||
        [className hasPrefix:@"OH"])
        displayName = [className substringFromIndex:2];
    else
        displayName = className;

    return [self initWithName:displayName];
}

- initWithName:(NSString *)name;
{
    if (![super init])
        return nil;

    contentInfo = [[OWContentInfo alloc] initWithContent:self typeString:name];

    return self;
}

- (void)dealloc;
{
    [contentInfo nullifyContent];
    [contentInfo release];

    [super dealloc];
}


// OWContent protocol

- (OWContentType *)contentType;
{
    [self doesNotRecognizeSelector:_cmd];
    return nil;
}

- (OWContentInfo *)contentInfo;
{
    return contentInfo;
}


@end
