// Copyright 1997-2002 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OWF/OWStream.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import <OWF/OWContentType.h>
#import <OWF/OWParameterizedContentType.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Content.subproj/OWStream.m,v 1.13 2002/03/09 01:53:49 kc Exp $")

@implementation OWStream

- initWithName:(NSString *)aName
{
    if ((self = [super initWithName:aName]) != nil)
        _parameterizedContentTypeLock = [[NSLock alloc] init];
    return self;
}

- (void)dealloc;
{
    [_parameterizedContentType release];
    [_parameterizedContentTypeLock release];
    [super dealloc];
}

- (id)newCursor;
{
    return nil;
}

//

- (void)setContentType:(OWContentType *)aContentType;
{
    OWParameterizedContentType *newType;
    
    newType = [[OWParameterizedContentType alloc] initWithContentType:aContentType];
    [self setFullContentType:newType];
    [newType release];
}

- (void)setFullContentType:(OWParameterizedContentType *)newParamaterizedContentType;
{
    [_parameterizedContentTypeLock lock];
    if (newParamaterizedContentType != _parameterizedContentType) {
        [_parameterizedContentType release];
        _parameterizedContentType = [newParamaterizedContentType retain];
    }
    [_parameterizedContentTypeLock unlock];
}

- (void)setContentTypeString:(NSString *)aString;
{
    if ([aString containsString:@";"])
        [self setFullContentType:[OWParameterizedContentType contentTypeForString:aString]];
    else
        [self setContentType:[OWContentType contentTypeForString:aString]];
}

//

- (void)dataEnd;
{
}

- (void)dataAbort;
{
}

//

- (void)waitForDataEnd;
{
}

- (BOOL)endOfData;
{
    return YES;
}

// OWContent protocol

- (OWContentType *)contentType;
{
    OWContentType *contentType;

    [_parameterizedContentTypeLock lock];
    contentType = [_parameterizedContentType contentType];
    [_parameterizedContentTypeLock unlock];
    return contentType;
}

// this is not in the OWContent protocol, but should be eventually
- (OWParameterizedContentType *)fullContentType;
{
    OWParameterizedContentType *parameterizedContentType;

    [_parameterizedContentTypeLock lock];
    parameterizedContentType = [_parameterizedContentType retain];
    [_parameterizedContentTypeLock unlock];
    return [parameterizedContentType autorelease];
}

- (OWCursor *)contentCursor;
{
    return [self newCursor];
}

- (unsigned long int)cacheSize;
{
    return 0;
}

- (BOOL)shareable;
{
    return YES;
}


// Debugging

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];
    if (_parameterizedContentType)
        [debugDictionary setObject:_parameterizedContentType forKey:@"_parameterizedContentType"];

    return debugDictionary;
}

@end
