// Copyright 1997-2002 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/OWSimpleTarget.h,v 1.6 2002/03/09 01:53:48 kc Exp $

#import <OmniFoundation/OFObject.h>

@class NSConditionLock;
@class OWContentInfo, OWContentType;

#import <OmniFoundation/OFWeakRetainConcreteImplementation.h>
#import <OWF/OWContentProtocol.h>
#import <OWF/OWTargetProtocol.h>

@interface OWSimpleTarget : OFObject <OWTarget, OFWeakRetain>
{
    OWContentInfo *parentContentInfo;
    OWContentType *targetContentType;
    NSConditionLock *resultLock;
    id <OWContent> resultingContent;
    BOOL acceptsAlternateContent;
    NSString *targetTypeFormatString;
    OFWeakRetainConcreteImplementation_IVARS;
}

- initWithParentContentInfo:(OWContentInfo *)contentInfo targetContentType:(OWContentType *)contentType;

- (void)setAcceptsAlternateContent:(BOOL)shouldAcceptAlternateContent;
- (id <OWContent>)resultingContent;

- (void)setTargetTypeFormatString:(NSString *)newFormatString;  // defaults to "%@ File". NB: The string passed to this method must already be localized into the user's language.

OFWeakRetainConcreteImplementation_INTERFACE

@end
