// Copyright 1997-2002 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Pipelines.subproj/OWContentTypeLink.h,v 1.8 2002/03/09 01:53:51 kc Exp $

#import <OmniFoundation/OFObject.h>

@class OWContentType, OWProcessorDescription;

@interface OWContentTypeLink : OFObject
{
    OWContentType *sourceContentType;
    OWContentType *targetContentType;
    OWProcessorDescription *processorDescription;
    float cost;
}

- initWithProcessorDescription:(OWProcessorDescription *)aProcessorDescription sourceContentType:(OWContentType *)fromContentType targetContentType:(OWContentType *)toContentType cost:(float)aCost;

- (OWContentType *)sourceContentType;
- (OWContentType *)targetContentType;
- (OWProcessorDescription *) processorDescription;
- (NSString *)processorClassName;
- (float)cost;

@end
