// Copyright 1997-2002 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Pipelines.subproj/OWPipelineCoordinator.h,v 1.9 2002/03/09 01:53:51 kc Exp $

#import <OmniFoundation/OFObject.h>

@class NSLock, NSMutableArray;
@class OWPipeline;

#import <OWF/OWAddressProtocol.h>

@interface OWPipelineCoordinator : OFObject
{
    id <OWAddress> address;
    OWPipeline *buildingPipeline;
    NSLock *coordinatorLock;
    NSMutableArray *queuedPipelines;
}

+ (OWPipelineCoordinator *)pipelineCoordinatorForAddress:(id <OWAddress>)anAddress;
- (void)buildPipeInPipeline:(OWPipeline *)aPipeline;
- (void)pipebuildingComplete:(OWPipeline *)aPipeline;
- (void)pipelineAbort:(OWPipeline *)aPipeline;

@end
