// Copyright 1997-2002 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Pipelines.subproj/OWTargetProtocol.h,v 1.16 2002/03/09 01:53:51 kc Exp $

#import <Foundation/NSObject.h>

@class NSNotification;
@class OWContentInfo, OWContentType, OWPipeline;

#import <OWF/OWContentProtocol.h>

// WARNING: Methods in this protocol may be called from any thread

typedef enum {
    OWTargetContentDisposition_ContentAccepted,
        // Accept this content, cancel earlier pipelines
    OWTargetContentDisposition_ContentRejectedSavePipeline,
        // Reject this content, but keep this pipeline around in case we want to try refetching the content later
    OWTargetContentDisposition_ContentRejectedCancelPipeline,
        // Reject this content, cancel this pipeline (default for optional methods)
    OWTargetContentDisposition_ContentUpdatedOrTargetChanged
        // The content or target has changed, do more processing
} OWTargetContentDisposition;

@protocol OWTarget
// Targets must call +[OWPipeline invalidatePipelinesForTarget:self] in order to be released, so they should do it in their -invalidate methods (or some such) which is called by their owning classes when the owning class is going away.

- (OWContentType *)targetContentType;
    // This returns the eventual ("target") content type desired by the target.

- (OWTargetContentDisposition)pipeline:(OWPipeline *)aPipeline hasContent:(id <OWContent>)someContent;
    // Pipelines deliver content to their targets using this method.  If the target accepts this content, it should return OWTargetContentAccepted.

// TODO: Make the remaining methods optional.

- (OWContentInfo *)parentContentInfo;
    // This links the target into the app's pipeline hierarchy.  Return your parent's content info (e.g., an inline image would return its html page's content info) or a header content info (+[OWContentInfo headerContentInfoWithName:]).

- (NSString *)targetTypeFormatString;
    // The targetTypeFormatString is used to give the user some notion of what a pipeline is doing (e.g., loading a document).  A %@ in the string will be replaced with the content type string (e.g. @"%@ Document" -> "HTML Document").

@end

@protocol OWOptionalTarget <OWTarget>

- (void)pipelineDidBegin:(OWPipeline *)aPipeline;
    // Called when the pipeline first starts processing content.

- (OWTargetContentDisposition)pipeline:(OWPipeline *)aPipeline hasAlternateContent:(id <OWContent>)someContent;
    // Called when the pipeline can't convert content to the desired target content type.  (A web browser controller would redirect the content to a download controller, and return OWTargetContentDisposition_ContentUpdatedOrTargetChanged.)
    // If a target does not implement this method, the pipeline will act as though it were implemented to simply return OWTargetContentDisposition_ContentRejectedCancelPipeline.

- (OWTargetContentDisposition)pipeline:(OWPipeline *)aPipeline hasErrorContent:(id <OWContent>)someContent;
    // When the pipeline encounters an error condition, it will generate some content describing the error and call this method.
    // If a target does not implement this method, the pipeline will act as though it were implemented to simply return OWTargetContentDisposition_ContentRejectedCancelPipeline.

- (void)pipelineDidEnd:(OWPipeline *)aPipeline;
    // Called when the pipeline deactivates.

- (void)pipelineTreeDidActivate:(NSNotification *)aPipeline;
    // Called when the pipeline or one of its children becomes active.

- (void)pipelineTreeDidDeactivate:(NSNotification *)aPipeline;
    // Called when the pipeline and all its children become inactive.

- (void)parentContentInfoLostContent;

- (NSString *)expectedContentTypeString;
    // If we have some idea what sort of content we'll be getting, we can implement this method to give this hint to the pipeline.

- (void)updateStatusForPipeline:(OWPipeline *)pipeline;

@end
