// Copyright 1997-2002 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Pipelines.subproj/OWWebPipeline.h,v 1.10 2002/03/09 01:53:52 kc Exp $

#import <OWF/OWPipeline.h>

typedef enum {
    OWWebPipelineForwardHistoryAction,
    OWWebPipelineBackwardHistoryAction,
    OWWebPipelineReloadHistoryAction
} OWWebPipelineHistoryAction;

@class OFScheduledEvent;

@interface OWWebPipeline : OWPipeline
{
    OWWebPipelineHistoryAction historyAction;
    OWContentInfo *referringContentInfo;
    id <OWAddress> referringAddress;
    OFScheduledEvent *refreshEvent;
    
    struct {
        unsigned int proxyCacheDisabled:1;
    } webPipelineFlags;
}

- (OWWebPipelineHistoryAction)historyAction;
- (void)setHistoryAction:(OWWebPipelineHistoryAction)newHistoryAction;

- (id <OWAddress>)referringAddress;
- (void)setReferringAddress:(id <OWAddress>)anAddress;

- (OWContentInfo *)referringContentInfo;
- (void)setReferringContentInfo:(OWContentInfo *)anInfo;

- (BOOL)proxyCacheDisabled;
- (void)setProxyCacheDisabled:(BOOL)newDisabled;

@end
