// Copyright 2000-2002 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/OWDataStreamCharacterProcessor.h,v 1.8 2002/03/09 01:53:52 kc Exp $
// Created by wiml on Wed Jul 26 2000.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/OWDataStreamCharacterProcessor.h,v 1.8 2002/03/09 01:53:52 kc Exp $

#import <OWF/OWProcessor.h>
#import <CoreFoundation/CFString.h>

@class OWDataStreamCharacterCursor, OWParameterizedContentType, OWPipeline;

// If this key is set in the pipeline's context dictionary, it should have a value which is an NSNumber indicating the CFStringEncoding to use regardless of the charset header(s).
extern NSString *OWEncodingOverrideContextKey;

@interface OWDataStreamCharacterProcessor : OWProcessor
{
    OWDataStreamCharacterCursor *characterCursor;
}

+ (CFStringEncoding)defaultStringEncoding;
+ (CFStringEncoding)stringEncodingForDefault:(NSString *)encodingName;
+ (NSString *)defaultForCFEncoding:(CFStringEncoding)anEncoding;
+ (CFStringEncoding)stringEncodingForIANACharSetName:(NSString *)charset;

+ (CFStringEncoding)stringEncodingForContentType:(OWParameterizedContentType *)aType; // returns InvalidId if unspecified; call -defaultStringEncoding

+ (NSString *)charsetForCFEncoding:(CFStringEncoding)anEncoding;

@end
