// Copyright 1997-2002 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OWF/OWDataStreamProcessor.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import <OWF/OWDataStream.h>
#import <OWF/OWDataStreamCursor.h>
#import <OWF/OWPipeline.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/OWDataStreamProcessor.m,v 1.8 2002/03/09 01:53:52 kc Exp $")

@implementation OWDataStreamProcessor

// Init and dealloc

- initWithPipeline:(OWPipeline *)aPipeline;
{
    if (![super initWithPipeline:aPipeline])
        return nil;

    dataCursor = [[(id <OWOptionalContent>)[pipeline lastContent] contentCursor] retain];
    if (!dataCursor) {
        [self release];
        return nil;
    }

    return self;
}

- (void)dealloc;
{
    [dataCursor release];
    [super dealloc];
}

// OWProcessor subclass

- (void)abortProcessing;
{
    [dataCursor abort];
    [super abortProcessing];
}

// Debugging

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];
    if (dataCursor)
        [debugDictionary setObject:dataCursor forKey:@"dataCursor"];

    return debugDictionary;
}

@end
