// Copyright 1997-2002 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/Protocols.subproj/HTTP.subproj/OWHTTPProcessor.h,v 1.22 2002/03/09 01:53:52 kc Exp $

#import <OWF/OWProcessor.h>

@class OWHTTPSessionQueue;
@class OWDataStream;
@class OWAuthorizationCredential;

@interface OWHTTPProcessor : OWProcessor
{
    OWHTTPSessionQueue *queue;
    OWDataStream *dataStream;
    NSArray *credentials;
}

- (Class)sessionQueueClass;
- (void)startProcessingInHTTPSessionQueue:(OWHTTPSessionQueue *)queue;

- (void)handleSessionException:(NSException *)anException;

- (OWDataStream *)dataStream;
- (void)setDataStream:(OWDataStream *)aDataStream;

- (NSArray *)credentials;
- (void)addCredential:(OWAuthorizationCredential *)newCredential;

@end

