// Copyright 1997-2002 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OWF/OWHTTPProcessor.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import <OWF/OWAddress.h>
#import <OWF/OWDataStream.h>
#import <OWF/OWHTTPSessionQueue.h>
#import <OWF/OWProxyServer.h>
#import <OWF/OWSourceProcessor.h>
#import <OWF/OWURL.h>
#import <OWF/OWWebPipeline.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/Protocols.subproj/HTTP.subproj/OWHTTPProcessor.m,v 1.47 2002/03/09 01:53:52 kc Exp $")

@implementation OWHTTPProcessor

// Class variables

+ (void)didLoad;
{
    [self registerProcessorClass:self fromContentType:[OWURL contentTypeForScheme:@"http"] toContentType:[OWSourceProcessor sourceContentType] cost:1.0];
}

// Init and dealloc

- (void)dealloc;
{
    [dataStream release];
    [queue release];
    [credentials release];
    [super dealloc];
}

// API

- (Class)sessionQueueClass;
{
    return [OWHTTPSessionQueue class];
}

- (void)startProcessingInHTTPSessionQueue:(OWHTTPSessionQueue *)aQueue;
{
    queue = [aQueue retain];
    if ([queue queueProcessor:self])
        [super startProcessing];
}

- (void)handleSessionException:(NSException *)anException;
{
    if (status != OWProcessorAborting)
        [self handleProcessingException:anException];
    [self processAbort];
}

- (OWDataStream *)dataStream;
{
    return dataStream;
}

- (void)setDataStream:(OWDataStream *)aDataStream;
{
    [dataStream release];
    dataStream = [aDataStream retain];
}

- (NSArray *)credentials;
{
    return credentials;
}

- (void)addCredential:(OWAuthorizationCredential *)newCredential;
{
    NSMutableArray *newCredentials = [[NSMutableArray alloc] initWithCapacity: 1 + [credentials count]];

    [newCredentials addObject:newCredential];
    if (credentials)
        [newCredentials addObjectsFromArray:credentials];
    
    [credentials release];
    credentials = [newCredentials copy];

    [newCredentials release];
}

// OWProcessor subclass

- (void)startProcessing;
{
    NS_DURING {
        OWAddress *address;

        address = (OWAddress *)[pipeline lastContent];
        if ([[address proxyURL] netLocation] == nil) {
            [NSException raise:@"OWHTTPProcessorAddressMissingServer" format:NSLocalizedStringFromTableInBundle(@"The name of the web server is missing from the address '%@'.", @"OWF", [OWHTTPProcessor bundle], httpprocessor error - URL does not contain a server address), [[address proxyURL] compositeString]];
        }
        [self startProcessingInHTTPSessionQueue:[[self sessionQueueClass] httpSessionQueueForAddress:address]];
    } NS_HANDLER {
        if (status != OWProcessorAborting)
            [self handleProcessingException:localException];
        [self processAbort];
        [self retire];
    } NS_ENDHANDLER;
}

- (void)processInThread;
{
    [queue runSession];
}

- (void)abortProcessing;
{
    [queue abortProcessingForProcessor:self];
    [dataStream dataAbort];
    [super abortProcessing];
}

@end

