// Copyright 2001-2002 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OWAboutURLProcessor.h"

#import <Foundation/Foundation.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OmniBase/OmniBase.h>
#import <OWF/OWAddress.h>
#import <OWF/OWURL.h>
#import <OWF/OWPipeline.h>
#import <OWF/OWSourceProcessor.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Processors.subproj/Protocols.subproj/OWAboutURLProcessor.m,v 1.2 2002/03/09 01:53:52 kc Exp $");

@implementation OWAboutURLProcessor

static NSString *aboutAliasFilename = nil;

+ (void)didLoad;
{
    [self registerProcessorClass:self fromContentType:[OWURL contentTypeForScheme:@"about"] toContentType:[OWSourceProcessor sourceContentType] cost:1.0];
}

+ (void)initialize
{
    if(aboutAliasFilename == nil) {
        aboutAliasFilename = [[[NSBundle bundleForClass:[self class]] pathForResource:@"aboutSchemeAliases" ofType:@"plist"] retain];
    }
    
    [super initialize];
}

// Init and dealloc

- initWithPipeline:(OWPipeline *)aPipeline;
{    
    if (![super initWithPipeline:aPipeline])
        return nil;

    aboutAddress = [[pipeline lastContent] retain];

    return self;
}

- (void)dealloc;
{
    [aboutAddress release];
    [super dealloc];
}

// Override -startProcessing, since we just do a dictionary lookup (well, we read a file too) and add a new address, so there's no need to spawn another thread.
- (void)startProcessing
{
    [self processInThread];
}

- (void)process
{
    OWURL *aboutURL = [aboutAddress url];
    NSString *aboutWhat = [aboutURL schemeSpecificPart];
    NSDictionary *aliases = [NSDictionary dictionaryWithContentsOfFile:aboutAliasFilename];
    NSString *redirectTo;
    OWAddress *newAddress;
    
    if (!aboutWhat)
        aboutWhat = @"";
    
    if (!aliases || !(redirectTo = [aliases objectForKey:aboutWhat])) {
        NSException *exception;
        
        if (!aliases)
            exception = [NSException exceptionWithName:@"OWAboutMissingResource" reason:NSLocalizedStringFromTableInBundle(@"Unable to locate about: aliases resource", @"OWF", [OWAboutURLProcessor bundle], about: protocol error) userInfo:nil];
        else
            exception = [NSException exceptionWithName:@"Not Found" reason:[NSString stringWithFormat:NSLocalizedStringFromTableInBundle(@"Unknown about: item \"%@\"", @"OWF", [OWAboutURLProcessor bundle], the about: has its version of 404-not-found), aboutWhat] userInfo:nil];
        [exception raise];
    }
    
        
    newAddress   =   [OWAddress addressWithURL:[aboutURL urlFromRelativeString:redirectTo]
                                        target:[aboutAddress target]
                                  methodString:[aboutAddress methodString]
                              methodDictionary:[aboutAddress methodDictionary]
                                        effect:[aboutAddress effect]
                             forceAlwaysUnique:NO
                             contextDictionary:[aboutAddress contextDictionary]];
    
    [pipeline addContent:newAddress];
    [pipeline cacheContent];
    [pipeline startProcessingContent];
}

@end

