// Copyright 2000-2002 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OWAnchorsProcessor.h"

#import <OmniBase/OmniBase.h>
#import <OWF/OWF.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OWF/Tests/OWFWebPounder/OWAnchorsProcessor.m,v 1.5 2002/03/09 01:53:53 kc Exp $")

NSString *OWAnchorsResultContentTypeString = @"ObjectStream/Anchors";

static OWContentType *OWAnchorsProcessorSourceContentType = nil;
static OWContentType *OWAnchorsProcessorResultContentType = nil;

static OWSGMLTagType *anchorTagType;
static unsigned int   anchorHrefAttributeIndex;

@implementation OWAnchorsProcessor

+ (void) didLoad;
{
    OWSGMLMethods *methods;
    OWSGMLDTD *dtd;

    OWAnchorsProcessorSourceContentType = [[OWContentType contentTypeForString: @"ObjectStream/sgml"] retain];
    OWAnchorsProcessorResultContentType = [[OWContentType contentTypeForString: OWAnchorsResultContentTypeString] retain];
    
    [self registerProcessorClass: self
                 fromContentType: OWAnchorsProcessorSourceContentType
                   toContentType: OWAnchorsProcessorResultContentType
                            cost: 1.0];

    dtd = [self dtd];
    anchorTagType = [dtd tagTypeNamed:@"a"];
    anchorHrefAttributeIndex = [anchorTagType addAttributeNamed:@"href"];

    methods = [self sgmlMethods];
    [methods registerMethod:@"Anchor" forTagName:@"a"];
}

+ (OWContentType *) anchorsContentType;
{
    return OWAnchorsProcessorResultContentType;
}


- initWithPipeline:(OWPipeline *)aPipeline
{
    if (![super initWithPipeline:aPipeline])
        return nil;

    _outputObjectStream = [[OWObjectStream alloc] init];
    [_outputObjectStream setContentTypeString: OWAnchorsResultContentTypeString];
    
    return self;
}

- (void) dealloc;
{
    [_outputObjectStream release];
    [super dealloc];
}


//
// OWSGMLProcessor subclass
//

- (void)processBegin;
{
    [super processBegin];
    [self setStatusString:@"Finding anchors"];
}

- (void)process;
{
    [super process];
}

- (void)processEnd;
{
    [_outputObjectStream dataEnd];
    [pipeline addContent: _outputObjectStream];
    [pipeline cacheContent];
    [pipeline startProcessingContent];
}

//
// Registered SGML methods
//

- (void)processAnchorTag:(OWSGMLTag *)tag;
{
//    NSLog(@"anchor = %@", tag);
    [_outputObjectStream writeObject: tag];
}

@end

