// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniAppKit/OAApplication.h>

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#ifdef RHAPSODY
#import <OmniBase/system.h>  // for {s,g}et[e]{g,u}id
#endif

#import <OmniAppKit/OAAppkitQueueProcessor.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/OAApplication.m,v 1.17 2000/03/01 23:58:24 bungi Exp $")

@implementation OAApplication

+ (void)setupOmniApplication;
{
    [OBPostLoader processClasses];
    [OFQueueProcessor startAppkitQueueProcessor];
}

+ (NSApplication *)sharedApplication;
{
    static OAApplication *omniApplication = nil;

    if (omniApplication)
        return omniApplication;

    omniApplication = (id)[super sharedApplication];
    [OAApplication setupOmniApplication];
    return omniApplication;
}

- (void)finishLaunching;
{
#if 0
    // TJW - In MacOS X DP3, this will break NSUserDefaults -- it will return nil for anything
    // in NSArgumentDomain after this.  Since this code doesn't work under DP3 anway ...
    
    NSString *appVersionString;
    NSString *specialTextColor = nil;

    appVersionString = [[[NSBundle mainBundle] infoDictionary] objectForKey:@"NSAppVersion"];
    specialTextColor = @"0.0 0.6 0.3";
    if ([appVersionString containsString:@"beta"])
        specialTextColor = @"0.0 0.6 0.3";
    else if ([appVersionString containsString:@"release candidate"])
        specialTextColor = @"1.0 0.8 0.0";

    if (specialTextColor) {
        NSUserDefaults *standardUserDefaults;
        NSMutableDictionary *dictionary;

        standardUserDefaults = [NSUserDefaults standardUserDefaults];

        dictionary = [[standardUserDefaults volatileDomainForName:NSArgumentDomain] mutableCopy];
        [dictionary setObject:specialTextColor forKey:@"textColor"];
        [dictionary setObject:specialTextColor forKey:@"windowFrameTextColor"];
        [dictionary setObject:specialTextColor forKey:@"controlTextColor"];
        [standardUserDefaults removeVolatileDomainForName:NSArgumentDomain];
        [standardUserDefaults setVolatileDomain:dictionary forName:NSArgumentDomain];
        [dictionary release];
   }
#endif
    
    [super finishLaunching];
}


- (void)run;
{
    BOOL stillRunning = YES;

    exceptionCount = 0;
    exceptionCheckpointDate = [[NSDate alloc] init];
    do {
        NS_DURING {
            [super run];
            stillRunning = NO;
        } NS_HANDLER {
            if (++exceptionCount % 300 == 0) {
                if ([exceptionCheckpointDate timeIntervalSinceNow] > -3.0)
                    stillRunning = NO; // 300 exceptions in 3 seconds: abort
                [exceptionCheckpointDate release];
                exceptionCheckpointDate = [[NSDate alloc] init];
                exceptionCount = 0;
            }
            if (localException) {
                if (_appFlags._hasBeenRun)
                    [self handleRunException:localException];
                else
                    [self handleInitException:localException];
            }
        } NS_ENDHANDLER;
    } while (stillRunning && _appFlags._hasBeenRun);
}

- (void)sendEvent:(NSEvent *)event;
{
    // Don't disable mainThread queue processing here since that would prevent
    // queue processing from occuring in modal loops!
    
    //[OFQueueProcessor disableAppkitQueueEventProcessing];
    NS_DURING {
        [super sendEvent:event];
    } NS_HANDLER {
        //[OFQueueProcessor reenableAppkitQueueEventProcessing];
        if ([[localException name] isEqualToString:NSAbortModalException] || [[localException name] isEqualToString:NSAbortPrintingException])
            [localException raise];
        [self handleRunException:localException];
    } NS_ENDHANDLER;
    //[OFQueueProcessor reenableAppkitQueueEventProcessing];
}

- (void)handleInitException:(NSException *)anException;
{
    NSLog(@"%@", [anException reason]);
}

- (void)handleRunException:(NSException *)anException;
{
    NSLog(@"%@", [anException reason]);
    NSRunAlertPanel(nil, @"%@", nil, nil, nil, [anException reason]);
}

@end
